/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.swagger.Visibility;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.Caching;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.ClassExcluder;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.RoSpec;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.Tagger;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal.ValueSchemaFactory;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal._OpenApi;
import org.apache.causeway.viewer.restfulobjects.rendering.service.swagger.internal._Util;
import org.jspecify.annotations.Nullable;

class _OpenApiModelFactory {
    private static final String DQ = "";
    private final String basePath;
    private final Visibility visibility;
    private final SpecificationLoader specificationLoader;
    private final ValueSchemaFactory valueSchemaFactory;
    private final Tagger tagger;
    private final ClassExcluder classExcluder;
    private final Set<String> references = _Sets.newLinkedHashSet();
    private final Set<String> definitions = _Sets.newLinkedHashSet();
    private OpenAPI oa3;

    public _OpenApiModelFactory(String basePath, Visibility visibility, SpecificationLoader specificationLoader, Tagger tagger, ClassExcluder classExcluder, ValueSchemaFactory valuePropertyFactory) {
        this.basePath = basePath;
        this.visibility = visibility;
        this.specificationLoader = specificationLoader;
        this.tagger = tagger;
        this.classExcluder = classExcluder;
        this.valueSchemaFactory = valuePropertyFactory;
    }

    OpenAPI generate() {
        this.oa3 = new OpenAPI();
        String swaggerVersionInfo = String.format("swagger.io (%s)", OpenAPI.class.getPackage().getImplementationVersion());
        this.oa3.addServersItem(new Server().url(this.basePath));
        this.oa3.info(new Info().version(swaggerVersionInfo).title(this.visibility.name() + " API"));
        this.oa3.setComponents(new Components());
        this.appendRestfulObjectsSupportingPathsAndDefinitions();
        this.appendLinkModelDefinition();
        this.appendServicePathsAndDefinitions();
        this.appendObjectPathsAndDefinitions();
        this.appendDefinitionsForOrphanedReferences();
        this.oa3.setPaths(this.sorted((Map<String, PathItem>)this.oa3.getPaths()));
        this.oa3.getComponents().addSecuritySchemes("basicAuth", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic"));
        this.oa3.addSecurityItem(new SecurityRequirement().addList("basicAuth"));
        return this.oa3;
    }

    private Paths sorted(Map<String, PathItem> paths) {
        ArrayList<Map.Entry<String, PathItem>> entries = new ArrayList<Map.Entry<String, PathItem>>(paths.entrySet());
        entries.sort(new Comparator<Map.Entry<String, PathItem>>(){

            @Override
            public int compare(Map.Entry<String, PathItem> o1, Map.Entry<String, PathItem> o2) {
                String tag2;
                String tag1 = this.tagFor(o1);
                int tag = tag1.compareTo(tag2 = this.tagFor(o2));
                return tag != 0 ? tag : o1.getKey().compareTo(o2.getKey());
            }

            protected String tagFor(Map.Entry<String, PathItem> o1) {
                return o1.getValue().readOperations().stream().findFirst().map(operation -> operation.getTags().stream().findFirst().orElse("(no tag)")).orElse("(no tag)");
            }
        });
        LinkedHashMap sorted = new LinkedHashMap();
        entries.forEach(entry -> sorted.put((String)entry.getKey(), (PathItem)entry.getValue()));
        Paths _paths = new Paths();
        _paths.putAll(sorted);
        return _paths;
    }

    void appendServicePathsAndDefinitions() {
        for (ObjectSpecification spec : this.specificationLoader.snapshotSpecifications()) {
            List<ObjectAction> serviceActions = _Util.actionsOf(spec, this.visibility, this.classExcluder);
            if (serviceActions.isEmpty()) continue;
            this.appendServicePath(spec);
            for (ObjectAction serviceAction : serviceActions) {
                this.appendServiceActionInvokePath(spec, serviceAction);
            }
        }
    }

    private void debugTraverseAllSpecs(Collection<ObjectSpecification> allSpecs) {
        for (ObjectSpecification objectSpec : allSpecs) {
            objectSpec.streamAssociations(MixedIn.INCLUDED).collect(Collectors.toList());
            objectSpec.streamAnyActions(MixedIn.INCLUDED).collect(Collectors.toList());
        }
    }

    void appendObjectPathsAndDefinitions() {
        for (ObjectSpecification objectSpec : this.specificationLoader.snapshotSpecifications()) {
            if (objectSpec.isDomainService() || Facets.mixinIsPresent((ObjectSpecification)objectSpec) || this.visibility.isPublic() && !_Util.isVisibleForPublic(objectSpec) || objectSpec.isAbstract() || objectSpec.isValue() || this.classExcluder.exclude(objectSpec)) continue;
            List<OneToOneAssociation> objectProperties = _Util.propertiesOf(objectSpec, this.visibility);
            List<OneToManyAssociation> objectCollections = _Util.collectionsOf(objectSpec, this.visibility);
            List<ObjectAction> objectActions = _Util.actionsOf(objectSpec, this.visibility, this.classExcluder);
            if (objectProperties.isEmpty() && objectCollections.isEmpty()) continue;
            ObjectSchema causewayModel = this.appendObjectPathAndModelDefinitions(objectSpec);
            this.updateObjectModel(causewayModel, objectSpec, objectProperties, objectCollections);
            for (OneToManyAssociation objectCollection : objectCollections) {
                this.appendCollectionTo(objectSpec, objectCollection);
            }
            for (ObjectAction objectAction : objectActions) {
                this.appendObjectActionInvokePath(objectSpec, objectAction);
            }
        }
    }

    void appendRestfulObjectsSupportingPathsAndDefinitions() {
        String tag = "\u2026 asf restful objects supporting resources";
        this.oa3.path("/", new PathItem().get(_OpenApiModelFactory.newOperation("home-page", Caching.NON_EXPIRING, this.newRefProperty("RestfulObjectsSupportingHomePageRepr"), (ApiResponse response) -> response.description("OK")).addTagsItem("\u2026 asf restful objects supporting resources").description(RoSpec.HOMEPAGE_GET.fqSection())));
        this.addDefinition("RestfulObjectsSupportingHomePageRepr", (Schema<?>)_OpenApiModelFactory.newModel(RoSpec.HOMEPAGE_REPR.fqSection()));
        this.oa3.path("/user", new PathItem().get(_OpenApiModelFactory.newOperation("user", Caching.USER_INFO, this.newRefProperty("RestfulObjectsSupportingUserRepr"), (ApiResponse response) -> response.description("OK")).addTagsItem("\u2026 asf restful objects supporting resources").description(RoSpec.USER_GET.fqSection())));
        this.addDefinition("RestfulObjectsSupportingUserRepr", _OpenApiModelFactory.newModel(RoSpec.USER_REPR.fqSection()).addProperty("userName", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("roles", (Schema)_OpenApiModelFactory.arrayOfStrings()).addProperty("links", (Schema)_OpenApiModelFactory.arrayOfLinks()).addRequiredItem("userName").addRequiredItem("roles"));
        this.oa3.path("/services", new PathItem().get(_OpenApiModelFactory.newOperation("services", Caching.USER_INFO, this.newRefProperty("RestfulObjectsSupportingServicesRepr"), (ApiResponse response) -> response.description("OK")).addTagsItem("\u2026 asf restful objects supporting resources").description(RoSpec.DOMAIN_SERVICES_GET.fqSection())));
        this.addDefinition("RestfulObjectsSupportingServicesRepr", _OpenApiModelFactory.newModel(RoSpec.DOMAIN_SERVICES_REPR.fqSection()).addProperty("value", (Schema)_OpenApiModelFactory.arrayOfLinks()).addRequiredItem("userName").addRequiredItem("roles"));
        this.oa3.path("/version", new PathItem().get(_OpenApiModelFactory.newOperation("RestfulObjectsSupportingServicesRepr", Caching.NON_EXPIRING, new ObjectSchema(), (ApiResponse response) -> response.description("OK")).addTagsItem("\u2026 asf restful objects supporting resources").description(RoSpec.VERSION_GET.fqSection())));
        this.oa3.getComponents().addSchemas("RestfulObjectsSupportingServicesRepr", _OpenApiModelFactory.newModel(RoSpec.VERSION_REPR.fqSection()).addProperty("specVersion", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("implVersion", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("optionalCapabilities", new ObjectSchema().addProperty("blobsClobs", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("deleteObjects", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("domainModel", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("validateOnly", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("protoPersistentObjects", (Schema)_OpenApiModelFactory.stringProperty())).addRequiredItem("userName").addRequiredItem("roles"));
    }

    void appendLinkModelDefinition() {
        this.oa3.getComponents().addSchemas("LinkRepr", new ObjectSchema().addProperty("rel", _OpenApiModelFactory.stringProperty().description("the relationship of the resource to this referencing resource")).addProperty("href", _OpenApiModelFactory.stringProperty().description("the hyperlink reference (URL) of the resource")).addProperty("title", _OpenApiModelFactory.stringProperty().description("title to render")).addProperty("method", _OpenApiModelFactory.stringPropertyEnum("GET", "POST", "PUT", "DELETE").description("HTTP verb to access")).addProperty("type", _OpenApiModelFactory.stringProperty().description("Content-Type recognized by the resource (for HTTP Accept header)")).addProperty("arguments", new ObjectSchema().description("Any arguments, to send as query strings or in body")).addProperty("value", _OpenApiModelFactory.stringProperty().description("the representation of the link if followed")).addRequiredItem("rel").addRequiredItem("href").addRequiredItem("method"));
        this.oa3.getComponents().addSchemas("HrefRepr", new ObjectSchema().description("Abbreviated version of the Link resource, used primarily to reference non-value objects").addProperty("href", _OpenApiModelFactory.stringProperty().description("the hyperlink reference (URL) of the resource")).addRequiredItem("href"));
    }

    void appendServicePath(ObjectSpecification objectSpec) {
        String serviceId = objectSpec.logicalTypeName();
        PathItem path = new PathItem();
        this.oa3.path(String.format("/services/%s", serviceId), path);
        String serviceModelDefinition = serviceId + "Repr";
        String tag = this.tagForlogicalTypeName(serviceId, "> services");
        path.get(_OpenApiModelFactory.newOperation("object", Caching.TRANSACTIONAL, this.newRefProperty(serviceModelDefinition), (ApiResponse response) -> response.description("OK")).addTagsItem(tag).description(RoSpec.DOMAIN_SERVICE_GET.fqSection()));
        Schema model = _OpenApiModelFactory.newModel(RoSpec.DOMAIN_SERVICE_GET_SUCCESS.fqSection("representation of " + serviceId)).addProperty("title", (Schema)_OpenApiModelFactory.stringProperty()).addProperty("serviceId", (Schema)_OpenApiModelFactory.stringProperty()._default(serviceId)).addProperty("members", (Schema)new ObjectSchema());
        this.addDefinition(serviceModelDefinition, model);
    }

    ObjectSchema appendObjectPathAndModelDefinitions(ObjectSpecification objectSpec) {
        String logicalTypeName = objectSpec.logicalTypeName();
        ObjectSchema causewayModel = new ObjectSchema();
        String causewayModelDefinition = logicalTypeName + "Repr";
        this.addDefinition(causewayModelDefinition, (Schema<?>)causewayModel);
        PathItem path = new PathItem();
        this.oa3.path(String.format("/objects/%s/{objectId}", logicalTypeName), path);
        String tag = this.tagForlogicalTypeName(logicalTypeName, null);
        Operation operation = _OpenApiModelFactory.newOperation("object", Caching.TRANSACTIONAL, this.newRefProperty(causewayModelDefinition), (ApiResponse response) -> response.description(logicalTypeName + " , if Accept: application/json;profile=urn:org.apache.causeway/v2"));
        path.get(operation);
        operation.addTagsItem(tag).description(RoSpec.DOMAIN_OBJECT_GET.fqSection()).addParametersItem(_OpenApi.pathParameter().name("objectId"));
        return causewayModel;
    }

    void appendServiceActionPromptTo(ObjectSchema serviceMembers, ObjectAction action) {
        String actionId = action.getId();
        serviceMembers.addProperty(actionId, new ObjectSchema().addProperty("id", (Schema)_OpenApiModelFactory.stringPropertyEnum(actionId)).addProperty("memberType", (Schema)_OpenApiModelFactory.stringPropertyEnum("action")).addProperty("links", new ObjectSchema().addProperty("rel", (Schema)_OpenApiModelFactory.stringPropertyEnum(String.format("urn:org.restfulobjects:rels/details;action=%s", actionId))).addProperty("href", (Schema)_OpenApiModelFactory.stringPropertyEnum(String.format("actions/%s", actionId)))).addProperty("method", (Schema)_OpenApiModelFactory.stringPropertyEnum("GET")).addProperty("type", (Schema)_OpenApiModelFactory.stringPropertyEnum("application/json;profile=urn:org.restfulobjects:repr-types/object-action")));
    }

    void appendServiceActionInvokePath(ObjectSpecification serviceSpec, ObjectAction serviceAction) {
        String serviceId = serviceSpec.logicalTypeName();
        String actionId = serviceAction.getId();
        Can parameters = serviceAction.getParameters();
        PathItem path = new PathItem();
        this.oa3.path(String.format("/services/%s/actions/%s/invoke", serviceId, actionId), path);
        String tag = this.tagForlogicalTypeName(serviceId, "> services");
        Operation invokeOperation = _OpenApiModelFactory.newOperation(List.of("object", "action-result"), Caching.TRANSACTIONAL, this.actionReturnTypeFor(serviceAction), (ApiResponse response) -> response.description(serviceId + "#" + actionId + " , if Accept: application/json;profile=urn:org.apache.causeway/v2")).addTagsItem(tag).description(RoSpec.ACTION_INVOKE_GET.fqSection("(invoke) resource of " + serviceId + "#" + actionId));
        SemanticsOf semantics = serviceAction.getSemantics();
        if (semantics.isSafeInNature()) {
            path.get(invokeOperation);
            for (ObjectActionParameter parameter : parameters) {
                String describedAs = parameter.getStaticDescription().orElse(null);
                invokeOperation.addParametersItem(_OpenApi.queryParameter().name(parameter.getId()).description(RoSpec.ARGS_SIMPLE.fqSection(describedAs)).required(Boolean.valueOf(false)));
            }
            if (!parameters.isEmpty()) {
                invokeOperation.addParametersItem(_OpenApi.queryParameter().name("x-causeway-querystring").description(RoSpec.ARGS_PASSING.fqSection("all (formal) arguments as base64 encoded string")).required(Boolean.valueOf(false)));
            }
        } else {
            if (semantics.isIdempotentInNature()) {
                path.put(invokeOperation);
            } else {
                path.post(invokeOperation);
            }
            ObjectSchema bodyParam = new ObjectSchema();
            for (ObjectActionParameter parameter : parameters) {
                StringSchema valueProperty = _OpenApiModelFactory.stringProperty();
                bodyParam.addProperty(parameter.getId(), new ObjectSchema().addProperty("value", (Schema)valueProperty));
            }
            invokeOperation.requestBody(_OpenApi.requestBody("application/json", bodyParam)).addExtension("x-codegen-request-body-name", (Object)"body");
        }
    }

    void appendCollectionTo(ObjectSpecification objectSpec, OneToManyAssociation collection) {
        String logicalTypeName = objectSpec.logicalTypeName();
        String collectionId = collection.getId();
        PathItem path = new PathItem();
        this.oa3.path(String.format("/objects/%s/{objectId}/collections/%s", logicalTypeName, collectionId), path);
        String tag = this.tagForlogicalTypeName(logicalTypeName, null);
        Operation collectionOperation = _OpenApiModelFactory.newOperation("object-collection", Caching.TRANSACTIONAL, this.arrayPropertyOf(collection.getElementType()), (ApiResponse response) -> response.description(logicalTypeName + "#" + collectionId + " , if Accept: application/json;profile=urn:org.apache.causeway/v2")).addTagsItem(tag).description(RoSpec.COLLECTION_GET.fqSection("resource of " + logicalTypeName + "#" + collectionId)).addParametersItem(_OpenApi.pathParameter().name("objectId"));
        path.get(collectionOperation);
    }

    void appendObjectActionInvokePath(ObjectSpecification objectSpec, ObjectAction objectAction) {
        String logicalTypeName = objectSpec.logicalTypeName();
        String actionId = objectAction.getId();
        Can parameters = objectAction.getParameters();
        PathItem path = new PathItem();
        this.oa3.path(String.format("/objects/%s/{objectId}/actions/%s/invoke", logicalTypeName, actionId), path);
        String tag = this.tagForlogicalTypeName(logicalTypeName, null);
        Operation invokeOperation = _OpenApiModelFactory.newOperation("action-result", Caching.TRANSACTIONAL, this.actionReturnTypeFor(objectAction), (ApiResponse response) -> response.description(logicalTypeName + "#" + actionId)).addTagsItem(tag).description(RoSpec.ACTION_INVOKE_GET.fqSection("(invoke) resource of " + logicalTypeName + "#" + actionId)).addParametersItem(_OpenApi.pathParameter().name("objectId"));
        SemanticsOf semantics = objectAction.getSemantics();
        if (semantics.isSafeInNature()) {
            path.get(invokeOperation);
            for (ObjectActionParameter parameter : parameters) {
                String describedAs = parameter.getStaticDescription().orElse(null);
                invokeOperation.addParametersItem(_OpenApi.queryParameter().name(parameter.getId()).description(RoSpec.ARGS_SIMPLE.fqSection(describedAs)).required(Boolean.valueOf(false)));
            }
            if (!parameters.isEmpty()) {
                invokeOperation.addParametersItem(_OpenApi.queryParameter().name("x-causeway-querystring").description(RoSpec.ARGS_PASSING.fqSection("all (formal) arguments as base64 encoded string")).required(Boolean.valueOf(false)));
            }
        } else {
            if (semantics.isIdempotentInNature()) {
                path.put(invokeOperation);
            } else {
                path.post(invokeOperation);
            }
            ObjectSchema bodyParam = new ObjectSchema();
            for (ObjectActionParameter parameter : parameters) {
                ObjectSpecification specification = parameter.getElementType();
                Schema<?> valueProperty = specification.isValue() ? this.schemaFor(specification) : _OpenApiModelFactory.refToLinkModel();
                bodyParam.addProperty(parameter.getId(), new ObjectSchema().addProperty("value", valueProperty));
            }
            invokeOperation.requestBody(_OpenApi.requestBody("application/json", bodyParam)).addExtension("x-codegen-request-body-name", (Object)"body");
        }
    }

    void appendDefinitionsForOrphanedReferences() {
        for (String reference : this.getReferencesWithoutDefinition()) {
            this.oa3.getComponents().addSchemas(reference, new Schema());
        }
    }

    Schema<?> actionReturnTypeFor(ObjectAction objectAction) {
        return objectAction.getReturnType().isPlural() ? this.arrayPropertyOf(objectAction.getElementType()) : this.schemaFor(objectAction.getReturnType());
    }

    private ArraySchema arrayPropertyOf(ObjectSpecification objectSpecification) {
        ArraySchema arrayProperty = new ArraySchema();
        if (objectSpecification != null && objectSpecification.getCorrespondingClass() != Object.class) {
            arrayProperty.description("List of " + objectSpecification.logicalTypeName()).items(this.schemaFor(objectSpecification));
        } else {
            arrayProperty.items((Schema)new ObjectSchema());
        }
        return arrayProperty;
    }

    private Schema<?> schemaFor(@Nullable ObjectSpecification specification) {
        Optional<Schema<?>> valueSchema;
        ObjectSpecification elementSpec;
        Class cls;
        Class clazz = cls = specification != null ? specification.getCorrespondingClass() : null;
        if (cls == null || Void.TYPE.equals(cls) || Void.class.equals((Object)cls) || Object.class.equals((Object)cls)) {
            return new ObjectSchema();
        }
        if (specification.isPlural() && (elementSpec = (ObjectSpecification)Facets.elementSpec((FacetHolder)specification).orElse(null)) != null) {
            return this.arrayPropertyOf(elementSpec);
        }
        if (cls.isEnum()) {
            return this.valueSchemaFactory.schemaForValue(specification).orElseThrow();
        }
        if (specification.isValue() && (valueSchema = this.valueSchemaFactory.schemaForValue(specification)).isPresent()) {
            return valueSchema.get();
        }
        return this.newRefProperty(specification.logicalTypeName() + "Repr");
    }

    private void updateObjectModel(ObjectSchema model, ObjectSpecification objectSpecification, List<OneToOneAssociation> objectProperties, List<OneToManyAssociation> objectCollections) {
        String logicalTypeName = objectSpecification.logicalTypeName();
        String className = objectSpecification.getFullIdentifier();
        model.description(String.format("%s (%s)", logicalTypeName, className));
        for (OneToOneAssociation objectProperty : objectProperties) {
            model.addProperty(objectProperty.getId(), this.valueSchemaFactory.schemaForValue(objectProperty.getElementType()).orElseGet(() -> _OpenApiModelFactory.refToHrefModel()));
        }
        for (OneToManyAssociation objectCollection : objectCollections) {
            ObjectSpecification elementSpec = objectCollection.getElementType();
            model.addProperty(objectCollection.getId(), (Schema)this.arrayPropertyOf(elementSpec));
        }
    }

    static ObjectSchema newModel(String description) {
        return (ObjectSchema)new ObjectSchema().description(description).addProperty("links", (Schema)_OpenApiModelFactory.arrayOfLinks()).addProperty("extensions", (Schema)new MapSchema()).addRequiredItem("links").addRequiredItem("extensions");
    }

    static StringSchema stringProperty() {
        return new StringSchema();
    }

    static StringSchema stringPropertyEnum(String ... enumValues) {
        StringSchema stringProperty = _OpenApiModelFactory.stringProperty();
        stringProperty._enum(Arrays.asList(enumValues));
        if (enumValues.length >= 1) {
            stringProperty._default(enumValues[0]);
        }
        return stringProperty;
    }

    static ArraySchema arrayOfLinks() {
        return new ArraySchema().items(_OpenApiModelFactory.refToLinkModel());
    }

    static Schema<?> refToLinkModel() {
        return _OpenApi.refSchema("LinkRepr");
    }

    static Schema<?> refToHrefModel() {
        return _OpenApi.refSchema("HrefRepr");
    }

    static ArraySchema arrayOfStrings() {
        return new ArraySchema().items((Schema)_OpenApiModelFactory.stringProperty());
    }

    String tagForlogicalTypeName(String logicalTypeName, String fallback) {
        return this.tagger.tagForLogicalTypeName(logicalTypeName, fallback);
    }

    private Schema<?> newRefProperty(String model) {
        this.addSwaggerReference(model);
        return _OpenApi.refSchema(model);
    }

    private void addDefinition(String key, Schema<?> model) {
        this.addSwaggerDefinition(key);
        this.oa3.getComponents().addSchemas(key, model);
    }

    void addSwaggerReference(String model) {
        this.references.add(model);
    }

    void addSwaggerDefinition(String model) {
        this.definitions.add(model);
    }

    Set<String> getReferencesWithoutDefinition() {
        LinkedHashSet referencesCopy = _Sets.newLinkedHashSet(this.references);
        referencesCopy.removeAll(this.definitions);
        return referencesCopy;
    }

    private static Operation newOperation(String reprType, Caching caching, Schema<?> responsRef, Consumer<ApiResponse> responseRefiner) {
        return _OpenApiModelFactory.newOperation(List.of(reprType), caching, responsRef, responseRefiner);
    }

    private static Operation newOperation(List<String> reprTypes, Caching caching, Schema<?> responsRef, Consumer<ApiResponse> responseRefiner) {
        Operation operation = _OpenApi.operation(200, responsRef, _OpenApiModelFactory.supportedFormats(reprTypes), response -> {
            _OpenApi.withCacheControl(response, caching);
            responseRefiner.accept((ApiResponse)response);
        });
        return operation;
    }

    private static List<String> supportedFormats(List<String> reprTypes) {
        ArrayList supportedFormats = _Lists.newArrayList();
        supportedFormats.add("application/json");
        _Refs.BooleanReference supportsV1 = _Refs.booleanRef((boolean)false);
        reprTypes.forEach(reprType -> {
            if (reprType.equals("object") || reprType.equals("action-result")) {
                supportsV1.setValue(true);
            }
            supportedFormats.add("application/json;profile=urn:org.restfulobjects:repr-types/" + reprType);
        });
        if (supportsV1.isTrue()) {
            supportedFormats.add("application/json;profile=urn:org.apache.causeway/v2");
            supportedFormats.add("application/json;profile=urn:org.apache.causeway/v2;suppress=all");
        }
        return supportedFormats;
    }
}

