/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.mappers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.causeway.applib.exceptions.RecoverableException;
import org.apache.causeway.applib.services.exceprecog.RootCauseFinder;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.ExceptionWithBody;
import org.apache.causeway.viewer.restfulobjects.rendering.ExceptionWithHttpStatusCode;
import org.apache.causeway.viewer.restfulobjects.viewer.mappers.FailureUtil;
import org.apache.causeway.viewer.restfulobjects.viewer.mappers.entity.ExceptionDetail;
import org.apache.causeway.viewer.restfulobjects.viewer.mappers.entity.ExceptionPojo;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.serialization.SerializationStrategy;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ExceptionMapperAbstract<T extends Throwable>
implements ExceptionMapper<T> {
    @Context
    protected HttpHeaders httpHeaders;
    @Autowired(required=false)
    protected List<RootCauseFinder> rootCauseFinders;

    Response buildResponse(T ex) {
        return this.buildResponse(ex, this.determineStatusCode(ex));
    }

    Response buildResponse(T ex, RestfulResponse.HttpStatusCode httpStatusCode) {
        ExceptionWithBody exceptionWithBody;
        JsonRepresentation body;
        String message = ExceptionMapperAbstract.messageFor(ex);
        if (ex instanceof ExceptionWithBody && (body = (exceptionWithBody = (ExceptionWithBody)ex).getBody()) != null) {
            return this.buildResponse(httpStatusCode, message, body);
        }
        ExceptionPojo exceptionPojo = new ExceptionPojo(httpStatusCode.getStatusCode(), message, this.detailIfRequired(httpStatusCode, (Throwable)ex));
        return this.buildResponse(httpStatusCode, exceptionPojo);
    }

    private Response buildResponse(RestfulResponse.HttpStatusCode httpStatusCode, String message, JsonRepresentation body) {
        Response.ResponseBuilder builder = Response.status((Response.StatusType)httpStatusCode.getJaxrsStatusType());
        if (message != null) {
            builder.header(RestfulResponse.Header.WARNING.getName(), (Object)RestfulResponse.Header.WARNING.render((Object)message));
        }
        SerializationStrategy serializationStrategy = SerializationStrategy.JSON;
        builder.type(serializationStrategy.type(RepresentationType.GENERIC));
        builder.entity((Object)body.toString());
        return builder.build();
    }

    private RestfulResponse.HttpStatusCode determineStatusCode(T ex) {
        RestfulResponse.HttpStatusCode statusCode = FailureUtil.getFailureStatusCodeIfAny(ex);
        if (statusCode != null) {
            return statusCode;
        }
        Optional<RecoverableException> recoverableIfAny = ExceptionMapperAbstract.recoverableFor(ex);
        if (recoverableIfAny.isPresent()) {
            statusCode = RestfulResponse.HttpStatusCode.OK;
        } else if (ex instanceof ExceptionWithHttpStatusCode) {
            ExceptionWithHttpStatusCode exceptionWithHttpStatusCode = (ExceptionWithHttpStatusCode)ex;
            statusCode = exceptionWithHttpStatusCode.getHttpStatusCode();
        } else {
            statusCode = RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR;
        }
        return statusCode;
    }

    private static String messageFor(Throwable ex) {
        Optional<RecoverableException> recoverableIfAny = ExceptionMapperAbstract.recoverableFor(ex);
        return (recoverableIfAny.isPresent() ? (Throwable)recoverableIfAny.get() : ex).getMessage();
    }

    private static Optional<RecoverableException> recoverableFor(Throwable ex) {
        List chain = _Exceptions.getCausalChain((Throwable)ex);
        Optional<RecoverableException> recoverableIfAny = _NullSafe.stream((Collection)chain).filter(t -> t instanceof RecoverableException).map(t -> (RecoverableException)t).findFirst();
        return recoverableIfAny;
    }

    private ExceptionDetail detailIfRequired(RestfulResponse.HttpStatusCode httpStatusCode, Throwable ex) {
        return httpStatusCode == RestfulResponse.HttpStatusCode.NOT_FOUND || httpStatusCode == RestfulResponse.HttpStatusCode.OK ? null : new ExceptionDetail(ex, this.rootCauseFinders);
    }

    private Response buildResponse(RestfulResponse.HttpStatusCode httpStatusCode, ExceptionPojo exceptionPojo) {
        Response.ResponseBuilder builder = Response.status((Response.StatusType)httpStatusCode.getJaxrsStatusType());
        List acceptableMediaTypes = this.httpHeaders.getAcceptableMediaTypes();
        SerializationStrategy serializationStrategy = acceptableMediaTypes.contains(MediaType.APPLICATION_XML_TYPE) || acceptableMediaTypes.contains(RepresentationType.OBJECT_LAYOUT.getXmlMediaType()) ? SerializationStrategy.XML : SerializationStrategy.JSON;
        String message = exceptionPojo.getMessage();
        if (message != null) {
            builder.header(RestfulResponse.Header.WARNING.getName(), (Object)RestfulResponse.Header.WARNING.render((Object)message));
        }
        builder.type(serializationStrategy.type(RepresentationType.ERROR));
        builder.entity(serializationStrategy.entity(exceptionPojo));
        return builder.build();
    }
}

