/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.webmodule;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.TransactionalException;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.commons.internal.resources._Resources;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.causeway.core.webapp.modules.templresources.TemplateResourceCachingFilter;
import org.apache.causeway.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategy;
import org.apache.causeway.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategyUsingSession;
import org.springframework.beans.factory.annotation.Autowired;

public class CausewayRestfulObjectsInteractionFilter
implements Filter {
    public static final String AUTHENTICATION_SESSION_STRATEGY_KEY = "authenticationStrategy";
    public static final String AUTHENTICATION_SESSION_STRATEGY_DEFAULT = AuthenticationStrategyUsingSession.class.getName();
    public static final String LOGON_PAGE_KEY = "logonPage";
    public static final String WHEN_NO_SESSION_KEY = "whenNoSession";
    public static final String PASS_THRU_KEY = "passThru";
    public static final String RESTRICTED_KEY = "restricted";
    public static final String REDIRECT_TO_ON_EXCEPTION_KEY = "redirectToOnException";
    public static final String IGNORE_EXTENSIONS_KEY = "ignoreExtensions";
    public static final String CAUSEWAY_SESSION_FILTER_QUERY_STRING_FORCE_LOGOUT = "__causeway_force_logout";
    private static final Function<String, Pattern> STRING_TO_PATTERN = input -> Pattern.compile(".*\\." + input);
    @Autowired
    private InteractionService interactionService;
    @Autowired
    private SpecificationLoader specificationLoader;
    @Autowired
    private TransactionService transactionService;
    private List<String> passThruList = Collections.emptyList();
    private AuthenticationStrategy authStrategy;
    private List<String> restrictedPaths;
    private WhenNoSession whenNotAuthenticated;
    private String redirectToOnException;
    private Collection<Pattern> ignoreExtensions;

    static void redirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String redirectTo) throws IOException {
        httpResponse.sendRedirect(_Resources.combinePath((String)httpRequest.getContextPath(), (String)redirectTo));
    }

    public void init(FilterConfig config) throws ServletException {
        this.authStrategy = CausewayRestfulObjectsInteractionFilter.lookup(config.getInitParameter(AUTHENTICATION_SESSION_STRATEGY_KEY));
        this.lookupWhenNoSession(config);
        this.lookupPassThru(config);
        this.lookupRedirectToOnException(config);
        this.lookupIgnoreExtensions(config);
    }

    public static AuthenticationStrategy lookup(String authLookupStrategyClassName) {
        if (authLookupStrategyClassName == null) {
            authLookupStrategyClassName = AUTHENTICATION_SESSION_STRATEGY_DEFAULT;
        }
        return (AuthenticationStrategy)_InstanceUtil.createInstance((String)authLookupStrategyClassName, (Object[])new Object[0]);
    }

    private void lookupWhenNoSession(FilterConfig config) {
        String whenNoSessionStr = config.getInitParameter(WHEN_NO_SESSION_KEY);
        String logonPage = config.getInitParameter(LOGON_PAGE_KEY);
        if (logonPage != null) {
            if (whenNoSessionStr != null) {
                throw new IllegalStateException(String.format("The init-param '%s' is only provided for backwards compatibility; remove if the init-param '%s' has been specified", LOGON_PAGE_KEY, WHEN_NO_SESSION_KEY));
            }
            this.whenNotAuthenticated = WhenNoSession.RESTRICTED;
            this.restrictedPaths = List.of(logonPage);
            return;
        }
        this.whenNotAuthenticated = WhenNoSession.lookup(whenNoSessionStr);
        if (this.whenNotAuthenticated == WhenNoSession.RESTRICTED) {
            String restrictedPathsStr = config.getInitParameter(RESTRICTED_KEY);
            if (restrictedPathsStr == null) {
                throw new IllegalStateException(String.format("Require an init-param of '%s' key to be set.", RESTRICTED_KEY));
            }
            this.restrictedPaths = _Strings.splitThenStream((String)restrictedPathsStr, (String)",").collect(Collectors.toList());
        }
    }

    void lookupPassThru(FilterConfig config) {
        this.passThruList = this.lookupAndParsePassThru(config);
    }

    List<String> lookupAndParsePassThru(FilterConfig config) {
        String passThru = config.getInitParameter(PASS_THRU_KEY);
        return passThru != null && !passThru.equals("") ? Arrays.asList(passThru.split(",")) : Collections.emptyList();
    }

    private void lookupRedirectToOnException(FilterConfig config) {
        this.redirectToOnException = config.getInitParameter(REDIRECT_TO_ON_EXCEPTION_KEY);
    }

    private void lookupIgnoreExtensions(FilterConfig config) {
        this.ignoreExtensions = Collections.unmodifiableCollection(this.parseIgnorePatterns(config).collect(Collectors.toList()));
    }

    private Stream<Pattern> parseIgnorePatterns(FilterConfig config) {
        String ignoreExtensionsStr = config.getInitParameter(IGNORE_EXTENSIONS_KEY);
        if (ignoreExtensionsStr != null) {
            Stream ignoreExtensions = _Strings.splitThenStream((String)ignoreExtensionsStr, (String)",");
            return ignoreExtensions.map(STRING_TO_PATTERN);
        }
        return Stream.empty();
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Objects.requireNonNull(this.interactionService, "causewayInteractionFactory");
        Objects.requireNonNull(this.specificationLoader, "specificationLoader");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            CausewayRestfulObjectsInteractionFilter.ensureMetamodelIsValid(this.specificationLoader);
        }
        catch (Exception ex) {
            httpServletResponse.setStatus(503);
            return;
        }
        try {
            String queryString = httpServletRequest.getQueryString();
            if (queryString != null && queryString.contains(CAUSEWAY_SESSION_FILTER_QUERY_STRING_FORCE_LOGOUT)) {
                this.authStrategy.invalidate(httpServletRequest, httpServletResponse);
                return;
            }
            if (this.requestIsIgnoreExtension(this, httpServletRequest) || TemplateResourceCachingFilter.isCachedResource((HttpServletRequest)httpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            if (this.requestIsPassThru(httpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            InteractionContext authentication = this.authStrategy.lookupValid(httpServletRequest, httpServletResponse);
            if (authentication != null) {
                this.authStrategy.bind(httpServletRequest, httpServletResponse, authentication);
                this.interactionService.run(authentication, () -> this.transactionService.runWithinCurrentTransactionElseCreateNew(() -> chain.doFilter(request, response)).mapFailure(e -> new TransactionalException("", e)).ifFailureFail());
                return;
            }
            try {
                this.whenNotAuthenticated.handle(this, httpServletRequest, httpServletResponse, chain);
            }
            catch (IOException | RuntimeException | ServletException ex) {
                if (this.redirectToOnException != null) {
                    CausewayRestfulObjectsInteractionFilter.redirect(httpServletRequest, httpServletResponse, this.redirectToOnException);
                    this.interactionService.closeInteractionLayers();
                    return;
                }
                throw ex;
            }
        }
        finally {
            this.interactionService.closeInteractionLayers();
        }
    }

    private static void ensureMetamodelIsValid(SpecificationLoader specificationLoader) {
        ValidationFailures validationResult = (ValidationFailures)specificationLoader.getValidationResult().orElseThrow(() -> _Exceptions.illegalState((String)"Application is not fully initialized yet.", (Object[])new Object[0]));
        if (validationResult.hasFailures()) {
            throw new MetaModelInvalidException(validationResult.getAsLineNumberedString());
        }
    }

    protected boolean requestIsPassThru(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        for (String passThru : this.passThruList) {
            if (!requestURI.startsWith(passThru)) continue;
            return true;
        }
        return false;
    }

    private boolean requestIsIgnoreExtension(CausewayRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest) {
        String servletPath = httpRequest.getServletPath();
        for (Pattern extension : filter.ignoreExtensions) {
            if (!extension.matcher(servletPath).matches()) continue;
            return true;
        }
        return false;
    }

    public static enum WhenNoSession {
        UNAUTHORIZED("unauthorized"){

            @Override
            public void handle(CausewayRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.sendError(401);
            }
        }
        ,
        BASIC_AUTH_CHALLENGE("basicAuthChallenge"){

            @Override
            public void handle(CausewayRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Apache Causeway\"");
                httpResponse.sendError(401);
            }
        }
        ,
        AUTO("auto"){

            @Override
            public void handle(CausewayRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                if (this.fromWebBrowser(httpRequest)) {
                    httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Apache Causeway\"");
                }
                httpResponse.sendError(401);
            }

            private boolean fromWebBrowser(HttpServletRequest httpRequest) {
                String accept = httpRequest.getHeader("Accept");
                return accept.contains("text/html");
            }
        }
        ,
        CONTINUE("continue"){

            @Override
            public void handle(CausewayRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
        ,
        RESTRICTED("restricted"){

            @Override
            public void handle(CausewayRestfulObjectsInteractionFilter filter, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
                if (filter.restrictedPaths.contains(httpRequest.getServletPath())) {
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    return;
                }
                CausewayRestfulObjectsInteractionFilter.redirect(httpRequest, httpResponse, filter.restrictedPaths.get(0));
            }
        };

        private final String initParamValue;

        private WhenNoSession(String initParamValue) {
            this.initParamValue = initParamValue;
        }

        public static WhenNoSession lookup(String whenNoSessionStr) {
            for (WhenNoSession wns : WhenNoSession.values()) {
                if (!wns.initParamValue.equals(whenNoSessionStr)) continue;
                return wns;
            }
            throw new IllegalStateException("require an init-param of 'whenNoSession', taking a value of " + WhenNoSession.values());
        }

        public abstract void handle(CausewayRestfulObjectsInteractionFilter var1, HttpServletRequest var2, HttpServletResponse var3, FilterChain var4) throws IOException, ServletException;
    }
}

