/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.io.InputStream;
import java.util.Map;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.apache.causeway.commons.io.TextUtils;
import org.apache.causeway.commons.io.UrlUtils;
import org.apache.causeway.core.config.viewer.web.WebAppContextPath;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.rendering.UrlDecoderUtils;
import org.apache.causeway.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.causeway.viewer.restfulobjects.rendering.util.RequestParams;
import org.apache.causeway.viewer.restfulobjects.viewer.context.ResourceContext;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.ResourceDescriptor;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ResourceAbstract
implements HasMetaModelContext {
    @Autowired
    protected MetaModelContext metaModelContext;
    @Autowired
    protected WebAppContextPath webAppContextPath;
    @Context
    HttpHeaders httpHeaders;
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    @Context
    HttpServletRequest httpServletRequest;
    @Context
    HttpServletResponse httpServletResponse;
    @Context
    SecurityContext securityContext;
    @Context
    Providers providers;

    protected ResourceAbstract() {
    }

    protected ResourceContext createResourceContext(RepresentationType representationType, Where where, RepresentationService.Intent intent) {
        return this.createResourceContext(ResourceDescriptor.of(representationType, where, intent));
    }

    protected ResourceContext createResourceContext(ResourceDescriptor resourceDescriptor) {
        String queryStringIfAny = this.getUrlDecodedQueryStringIfAny();
        return this.createResourceContext(resourceDescriptor, RequestParams.ofQueryString((String)queryStringIfAny));
    }

    protected ResourceContext createResourceContext(ResourceDescriptor resourceDescriptor, InputStream arguments) {
        RequestParams urlDecodedQueryString = RequestParams.ofRequestBody((InputStream)arguments);
        return this.createResourceContext(resourceDescriptor, urlDecodedQueryString);
    }

    protected ResourceContext createResourceContext(ResourceDescriptor resourceDescriptor, RequestParams requestParams) {
        if (!this.getInteractionService().isInInteraction()) {
            throw RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.UNAUTHORIZED);
        }
        String restfulAbsoluteBase = this.getConfiguration().getViewer().getRestfulobjects().getBaseUri().orElseGet(() -> this.uriInfo.getBaseUri().toString());
        String restfulRelativeBase = this.uriInfo.getBaseUri().getRawPath();
        String serverAbsoluteBase = _Strings.suffix((String)TextUtils.cutter((String)restfulAbsoluteBase).keepAfterLast(restfulRelativeBase).getValue(), (String)"/");
        String applicationAbsoluteBase = _Strings.suffix((String)this.webAppContextPath.appendContextPath(serverAbsoluteBase), (String)"/");
        return this.resourceContext(resourceDescriptor, applicationAbsoluteBase, restfulAbsoluteBase, requestParams, this.httpServletRequest.getParameterMap());
    }

    public ResourceContext resourceContextForTesting(ResourceDescriptor resourceDescriptor, Map<String, String[]> requestParams) {
        return this.resourceContext(resourceDescriptor, "", "/restful", null, requestParams);
    }

    protected ManagedObject getObjectAdapterElseThrowNotFound(String domainType, String instanceIdEncoded, @NonNull UnaryOperator<RestfulObjectsApplicationException> onRoException) {
        if (onRoException == null) {
            throw new NullPointerException("onRoException is marked non-null but is null");
        }
        String instanceIdDecoded = UrlDecoderUtils.urlDecode((String)instanceIdEncoded);
        Bookmark bookmark = Bookmark.forLogicalTypeNameAndIdentifier((String)domainType, (String)instanceIdDecoded);
        return (ManagedObject)this.metaModelContext.getObjectManager().loadObject(bookmark).filter(_Predicates.not(ManagedObjects::isNullOrUnspecifiedOrEmpty)).orElseThrow(() -> (RestfulObjectsApplicationException)onRoException.apply(RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.NOT_FOUND, (String)"Could not determine adapter for bookmark: '%s'", (Object[])new Object[]{bookmark})));
    }

    private String getUrlDecodedQueryStringIfAny() {
        String queryStringIfAny = this.httpServletRequest.getQueryString();
        return UrlUtils.urlDecodeUtf8((String)queryStringIfAny);
    }

    private ResourceContext resourceContext(ResourceDescriptor resourceDescriptor, String applicationAbsoluteBase, String restfulAbsoluteBase, RequestParams urlUnencodedQueryString, Map<String, String[]> requestParams) {
        return new ResourceContext(resourceDescriptor, this.httpHeaders, this.providers, this.request, applicationAbsoluteBase, restfulAbsoluteBase, urlUnencodedQueryString, this.httpServletRequest, this.httpServletResponse, this.securityContext, this.metaModelContext, InteractionInitiatedBy.USER, requestParams);
    }

    public MetaModelContext getMetaModelContext() {
        return this.metaModelContext;
    }
}

