/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources.serialization;

import jakarta.ws.rs.core.MediaType;
import java.util.Collection;
import org.apache.causeway.commons.io.JsonUtils;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SerializationStrategy {
    XML{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            return jaxbAnnotatedObject;
        }
    }
    ,
    JSON{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            return JsonUtils.toStringUtf8((Object)jaxbAnnotatedObject, (JsonUtils.JacksonCustomizer[])new JsonUtils.JacksonCustomizer[]{JsonUtils::jaxbAnnotationSupport});
        }
    }
    ,
    JSON_INDENTED{

        @Override
        public Object entity(Object jaxbAnnotatedObject) {
            return JsonUtils.toStringUtf8((Object)jaxbAnnotatedObject, (JsonUtils.JacksonCustomizer[])new JsonUtils.JacksonCustomizer[]{JsonUtils::jaxbAnnotationSupport, JsonUtils::indentedOutput});
        }
    };


    public abstract Object entity(Object var1);

    public MediaType type(RepresentationType representationType) {
        return representationType.getXmlMediaType();
    }

    public static SerializationStrategy determineFrom(Collection<MediaType> acceptableMediaTypes) {
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (acceptableMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                return JSON;
            }
            if (!acceptableMediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) continue;
            return XML;
        }
        return JSON;
    }
}

