/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.links;

import java.io.Serializable;
import lombok.NonNull;

public interface Menuable
extends Serializable {
    public Kind menuableKind();

    public static SectionSeparator sectionSeparator() {
        return new SectionSeparator();
    }

    public static SectionLabel sectionLabel(@NonNull String sectionLabel) {
        if (sectionLabel == null) {
            throw new NullPointerException("sectionLabel is marked non-null but is null");
        }
        return new SectionLabel(sectionLabel);
    }

    public static final class SectionSeparator
    implements Menuable {
        private static final long serialVersionUID = 1L;

        @Override
        public Kind menuableKind() {
            return Kind.SECTION_SEPARATOR;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof SectionSeparator;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "Menuable.SectionSeparator()";
        }
    }

    public static final class SectionLabel
    implements Menuable {
        private static final long serialVersionUID = 1L;
        private final String sectionLabel;

        @Override
        public Kind menuableKind() {
            return Kind.SECTION_LABEL;
        }

        public SectionLabel(String sectionLabel) {
            this.sectionLabel = sectionLabel;
        }

        public String getSectionLabel() {
            return this.sectionLabel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SectionLabel)) {
                return false;
            }
            SectionLabel other = (SectionLabel)o;
            String this$sectionLabel = this.getSectionLabel();
            String other$sectionLabel = other.getSectionLabel();
            return !(this$sectionLabel == null ? other$sectionLabel != null : !this$sectionLabel.equals(other$sectionLabel));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sectionLabel = this.getSectionLabel();
            result = result * 59 + ($sectionLabel == null ? 43 : $sectionLabel.hashCode());
            return result;
        }

        public String toString() {
            return "Menuable.SectionLabel(sectionLabel=" + this.getSectionLabel() + ")";
        }
    }

    public static enum Kind {
        SECTION_SEPARATOR("list-separator"),
        SECTION_LABEL("list-section-label"),
        LINK("viewItem"),
        SUBMENU(null);

        private final String cssClassForLiElement;

        public boolean isSectionSeparator() {
            return this == SECTION_SEPARATOR;
        }

        public boolean isSectionLabel() {
            return this == SECTION_LABEL;
        }

        public boolean isLink() {
            return this == LINK;
        }

        private Kind(String cssClassForLiElement) {
            this.cssClassForLiElement = cssClassForLiElement;
        }

        public String getCssClassForLiElement() {
            return this.cssClassForLiElement;
        }
    }
}

