/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models.interaction.coll;

import lombok.NonNull;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.tabular.interactive.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.object.HasUiParentObject;
import org.apache.causeway.viewer.commons.model.object.UiObject;
import org.apache.causeway.viewer.wicket.model.models.interaction.BookmarkedObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.HasBookmarkedOwnerAbstract;

public class DataTableModelWkt
extends HasBookmarkedOwnerAbstract<DataTableInteractive>
implements HasUiParentObject<UiObject> {
    private static final long serialVersionUID = 1L;
    private final Identifier featureIdentifier;
    private final DataTableInteractive.Memento tableMemento;
    private static final String PROPERTY_NAME_MODEL_REUSE = "causeway.viewer.wicket.dataTableModelReuse";

    public static DataTableModelWkt forActionModel(@NonNull BookmarkedObjectWkt bookmarkedObjectModel, @NonNull ObjectAction actMetaModel, @NonNull Can<ManagedObject> args, @NonNull ManagedObject actionResult) {
        if (bookmarkedObjectModel == null) {
            throw new NullPointerException("bookmarkedObjectModel is marked non-null but is null");
        }
        if (actMetaModel == null) {
            throw new NullPointerException("actMetaModel is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (actionResult == null) {
            throw new NullPointerException("actionResult is marked non-null but is null");
        }
        ManagedAction managedAction = ManagedAction.of((ManagedObject)((ManagedObject)bookmarkedObjectModel.getObject()), (ObjectAction)actMetaModel, (Where)Where.NOT_SPECIFIED);
        DataTableInteractive table = DataTableInteractive.forAction((ManagedAction)managedAction, args, (ManagedObject)actionResult);
        DataTableInteractive.Memento tableMemento = table.getMemento(managedAction.getMementoForArgs(args));
        DataTableModelWkt model = new DataTableModelWkt(bookmarkedObjectModel, actMetaModel.getFeatureIdentifier(), tableMemento);
        model.setObject(table);
        return model;
    }

    @NonNull
    public static DataTableModelWkt forCollection(@NonNull BookmarkedObjectWkt bookmarkedObjectModel, @NonNull OneToManyAssociation collMetaModel) {
        if (bookmarkedObjectModel == null) {
            throw new NullPointerException("bookmarkedObjectModel is marked non-null but is null");
        }
        if (collMetaModel == null) {
            throw new NullPointerException("collMetaModel is marked non-null but is null");
        }
        DataTableInteractive table = DataTableInteractive.forCollection((ManagedCollection)ManagedCollection.of((ManagedObject)((ManagedObject)bookmarkedObjectModel.getObject()), (OneToManyAssociation)collMetaModel, (Where)Where.NOT_SPECIFIED));
        DataTableInteractive.Memento tableMemento = table.getMemento(null);
        DataTableModelWkt model = new DataTableModelWkt(bookmarkedObjectModel, collMetaModel.getFeatureIdentifier(), tableMemento);
        model.setObject(table);
        return model;
    }

    private DataTableModelWkt(BookmarkedObjectWkt bookmarkedObject, Identifier featureIdentifier, DataTableInteractive.Memento tableMemento) {
        super(bookmarkedObject);
        this.featureIdentifier = featureIdentifier;
        this.tableMemento = tableMemento;
    }

    public UiObject getParentUiModel() {
        return () -> super.getBookmarkedOwner();
    }

    protected DataTableInteractive load() {
        DataTableInteractive dataTableModel = this.tableMemento.getDataTableModel(this.getBookmarkedOwner());
        return dataTableModel;
    }

    public final void detach() {
        if (DataTableModelWkt.isDataTableModelDetachable()) {
            super.detach();
        }
    }

    @Deprecated
    private static boolean isDataTableModelDetachable() {
        return "false".equalsIgnoreCase(System.getenv(PROPERTY_NAME_MODEL_REUSE)) || "false".equalsIgnoreCase(System.getProperty(PROPERTY_NAME_MODEL_REUSE));
    }

    public Identifier getFeatureIdentifier() {
        return this.featureIdentifier;
    }
}

