/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.util;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.core.metamodel.spec.ActionScope;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.springframework.lang.Nullable;

public final class PageParameterUtils {
    public static final String CAUSEWAY_NO_HEADER_PARAMETER_NAME = "causeway.no.header";
    public static final String CAUSEWAY_NO_FOOTER_PARAMETER_NAME = "causeway.no.footer";
    private static final String NULL_ARG = "$nullArg$";

    public static PageParameters newPageParameters() {
        PageParameters newPageParameters = new PageParameters();
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle != null) {
            Optional.ofNullable(PageRequestHandlerTracker.getFirstHandler((RequestCycle)requestCycle)).map(IPageClassRequestHandler::getPageParameters).ifPresent(currentPageParameters -> {
                StringValue noFooter;
                StringValue noHeader = currentPageParameters.get(CAUSEWAY_NO_HEADER_PARAMETER_NAME);
                if (!noHeader.isNull()) {
                    newPageParameters.set(CAUSEWAY_NO_HEADER_PARAMETER_NAME, (Object)noHeader.toString());
                }
                if (!(noFooter = currentPageParameters.get(CAUSEWAY_NO_FOOTER_PARAMETER_NAME)).isNull()) {
                    newPageParameters.set(CAUSEWAY_NO_FOOTER_PARAMETER_NAME, (Object)noFooter.toString());
                }
            });
        }
        return newPageParameters;
    }

    public static Stream<INamedParameters.NamedPair> streamCurrentRequestParameters() {
        return Optional.ofNullable(RequestCycle.get()).stream().map(RequestCycle::getRequest).map(Request::getRequestParameters).flatMap(params -> params.getParameterNames().stream().map(key -> new INamedParameters.NamedPair(key, params.getParameterValue(key).toString())));
    }

    public static PageParameters createPageParametersForBookmark(Bookmark bookmark) {
        PageParameters pageParameters = PageParameterUtils.newPageParameters();
        PageParameterNames.OBJECT_OID.addStringTo(pageParameters, bookmark.stringify());
        return pageParameters;
    }

    public static PageParameters createPageParametersForObject(ManagedObject adapter) {
        PageParameters pageParameters = PageParameterUtils.newPageParameters();
        boolean isEntity = ManagedObjects.isIdentifiable((ManagedObject)adapter);
        if (isEntity) {
            ManagedObjects.stringify((ManagedObject)adapter).ifPresent(oidStr -> PageParameterNames.OBJECT_OID.addStringTo(pageParameters, (String)oidStr));
        }
        return pageParameters;
    }

    public static PageParameters createPageParametersForBookmarkablePageLink(ManagedObject adapter) {
        return ManagedObjects.isIdentifiable((ManagedObject)adapter) && !ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)adapter) ? UiObjectWkt.ofAdapter(Facets.projected((ManagedObject)adapter)).getPageParametersWithoutUiHints() : PageParameterUtils.createPageParametersForObject(null);
    }

    public static PageParameters createPageParametersForAction(ManagedObject adapter, ObjectAction objectAction, Can<ManagedObject> paramValues) {
        PageParameters pageParameters = PageParameterUtils.createPageParameters(adapter, objectAction);
        for (ManagedObject argumentAdapter : paramValues) {
            String encodedArg = PageParameterUtils.encodeArg(argumentAdapter);
            PageParameterNames.ACTION_ARGS.addStringTo(pageParameters, encodedArg);
        }
        return pageParameters;
    }

    public static Optional<Bookmark> toBookmark(PageParameters pageParameters) {
        String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
        return _Strings.isEmpty((CharSequence)oidStr) ? Optional.empty() : Optional.of(Bookmark.parseElseFail((String)oidStr));
    }

    private static PageParameters createPageParameters(ManagedObject adapter, ObjectAction objectAction) {
        PageParameters pageParameters = PageParameterUtils.newPageParameters();
        ManagedObjects.stringify((ManagedObject)adapter).ifPresent(oidStr -> PageParameterNames.OBJECT_OID.addStringTo(pageParameters, (String)oidStr));
        ActionScope actionScope = objectAction.getScope();
        PageParameterNames.ACTION_TYPE.addEnumTo(pageParameters, (Enum<?>)actionScope);
        ObjectSpecification actionOnTypeSpec = objectAction.getDeclaringType();
        if (actionOnTypeSpec != null) {
            PageParameterNames.ACTION_OWNING_SPEC.addStringTo(pageParameters, actionOnTypeSpec.getFullIdentifier());
        }
        String actionId = PageParameterUtils.determineActionId(objectAction);
        PageParameterNames.ACTION_ID.addStringTo(pageParameters, actionId);
        return pageParameters;
    }

    private static String determineActionId(ObjectAction objectAction) {
        Identifier identifier = objectAction.getFeatureIdentifier();
        if (identifier != null) {
            return identifier.getMemberNameAndParameterClassNamesIdentityString();
        }
        return objectAction.getId();
    }

    private static String encodeArg(ManagedObject adapter) {
        if (adapter == null) {
            return NULL_ARG;
        }
        return ManagedObjects.stringify((ManagedObject)adapter).orElse(null);
    }

    @Nullable
    private static ManagedObject decodeArg(@NonNull MetaModelContext mmc, ObjectSpecification objSpec, String encoded) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (NULL_ARG.equals(encoded)) {
            return null;
        }
        try {
            return Bookmark.parseUrlEncoded((String)encoded).flatMap(arg_0 -> ((ObjectManager)mmc.getObjectManager()).loadObject(arg_0)).orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private PageParameterUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

