/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import lombok.NonNull;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelAbstract;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataTableModelWkt;
import org.apache.wicket.Component;

public class EntityCollectionModelParented
extends EntityCollectionModelAbstract
implements UiHintContainer {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final UiObjectWkt entityModel;
    @NonNull
    private final CollectionLayoutData layoutData;
    public static final String HINT_KEY_SELECTED_ITEM = "selectedItem";

    public static EntityCollectionModelParented forParentObjectModel(@NonNull UiObjectWkt entityModel, @NonNull CollectionLayoutData layoutData) {
        if (entityModel == null) {
            throw new NullPointerException("entityModel is marked non-null but is null");
        }
        if (layoutData == null) {
            throw new NullPointerException("layoutData is marked non-null but is null");
        }
        OneToManyAssociation coll = entityModel.getTypeOfSpecification().getCollectionElseFail(layoutData.getId());
        DataTableModelWkt dataTableModel = DataTableModelWkt.forCollection(entityModel.bookmarkedObjectModel(), coll);
        return new EntityCollectionModelParented(dataTableModel, entityModel, layoutData);
    }

    protected EntityCollectionModelParented(@NonNull DataTableModelWkt delegate, @NonNull UiObjectWkt parentObjectModel, @NonNull CollectionLayoutData layoutData) {
        super(delegate, EntityCollectionModel.Variant.PARENTED);
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (parentObjectModel == null) {
            throw new NullPointerException("parentObjectModel is marked non-null but is null");
        }
        if (layoutData == null) {
            throw new NullPointerException("layoutData is marked non-null but is null");
        }
        this.entityModel = parentObjectModel;
        this.layoutData = layoutData;
    }

    @Override
    public String getHint(Component component, String attributeName) {
        return this.getEntityModel().getHint(component, attributeName);
    }

    @Override
    public void setHint(Component component, String attributeName, String attributeValue) {
        this.getEntityModel().setHint(component, attributeName, attributeValue);
    }

    @Override
    public void clearHint(Component component, String attributeName) {
        this.getEntityModel().clearHint(component, attributeName);
    }

    public OneToManyAssociation getMetaModel() {
        return (OneToManyAssociation)super.getMetaModel();
    }

    public Bookmark asHintingBookmark() {
        return this.entityModel.getOwnerBookmark();
    }

    @NonNull
    public UiObjectWkt getEntityModel() {
        return this.entityModel;
    }

    @NonNull
    public CollectionLayoutData getLayoutData() {
        return this.layoutData;
    }
}

