/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.modelhelpers;

import java.util.LinkedList;
import java.util.stream.Stream;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.util.pchain.ParentChain;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;

public class WhereAmIHelper {
    private final LinkedList<Object> reversedChainOfParents = new LinkedList();
    private final UiObjectWkt startOfChain;
    private final MetaModelContext commonContext;
    private final boolean isWhereAmIEnabled;

    public static WhereAmIHelper of(UiObjectWkt startOfChain) {
        return new WhereAmIHelper(startOfChain);
    }

    public WhereAmIHelper(UiObjectWkt startOfChain) {
        this.startOfChain = startOfChain;
        this.commonContext = startOfChain.getMetaModelContext();
        CausewayConfiguration.Viewer.Wicket.Breadcrumbs settings = this.commonContext.getConfiguration().getViewer().getWicket().getBreadcrumbs();
        this.isWhereAmIEnabled = settings.isEnabled();
        int maxChainLength = settings.getMaxParentChainLength();
        ManagedObject adapter = (ManagedObject)startOfChain.getObject();
        Object startNode = adapter.getPojo();
        ParentChain.of((SpecificationLoader)this.commonContext.getSpecificationLoader()).streamParentChainOf(startNode, maxChainLength).forEach(this.reversedChainOfParents::addFirst);
    }

    public UiObjectWkt getStartOfChain() {
        return this.startOfChain;
    }

    public boolean isShowWhereAmI() {
        if (!this.isWhereAmIEnabled) {
            return false;
        }
        return !this.reversedChainOfParents.isEmpty();
    }

    public Stream<UiObjectWkt> streamParentChainReversed() {
        if (!this.isWhereAmIEnabled) {
            return Stream.empty();
        }
        return this.reversedChainOfParents.stream().map(this::toEntityModel);
    }

    private UiObjectWkt toEntityModel(Object domainObject) {
        ManagedObject objectAdapter = this.commonContext.getObjectManager().adapt(domainObject);
        return UiObjectWkt.ofAdapter(objectAdapter);
    }
}

