/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.awt.image.BufferedImage;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.viewer.wicket.model.models.ScalarConvertingModel;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class FileUploadModels {
    public static ScalarConvertingModel<List<FileUpload>, Blob> blob(@NonNull UiAttributeWkt attributeModel) {
        return new FileUploadConvertingModel<Blob>(attributeModel){
            private static final long serialVersionUID = 1L;

            @Override
            Blob toScalarValue(@NonNull FileUpload fileUpload) {
                String contentType = fileUpload.getContentType();
                String clientFileName = fileUpload.getClientFileName();
                byte[] bytes = fileUpload.getBytes();
                Blob blob = new Blob(clientFileName, contentType, bytes);
                return blob;
            }
        };
    }

    public static ScalarConvertingModel<List<FileUpload>, Clob> clob(@NonNull UiAttributeWkt attributeModel, @NonNull Charset charset) {
        final String charsetName = charset.name();
        return new FileUploadConvertingModel<Clob>(attributeModel){
            private static final long serialVersionUID = 1L;

            @Override
            Clob toScalarValue(@NonNull FileUpload fileUpload) {
                String contentType = fileUpload.getContentType();
                String clientFileName = fileUpload.getClientFileName();
                String str = new String(fileUpload.getBytes(), charsetName);
                Clob clob = new Clob(clientFileName, contentType, (CharSequence)str);
                return clob;
            }
        };
    }

    public static ScalarConvertingModel<List<FileUpload>, BufferedImage> image(@NonNull UiAttributeWkt attributeModel) {
        return new FileUploadConvertingModel<BufferedImage>(attributeModel){
            private static final long serialVersionUID = 1L;

            @Override
            BufferedImage toScalarValue(@NonNull FileUpload fileUpload) {
                String contentType = fileUpload.getContentType();
                String clientFileName = fileUpload.getClientFileName();
                byte[] bytes = fileUpload.getBytes();
                Blob blob = new Blob(clientFileName, contentType, bytes);
                return blob.asImage().orElse(null);
            }
        };
    }

    @Generated
    private FileUploadModels() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static abstract class FileUploadConvertingModel<T>
    extends ScalarConvertingModel<List<FileUpload>, T> {
        private static final long serialVersionUID = 1L;

        protected FileUploadConvertingModel(@NonNull UiAttributeWkt attributeModel) {
            super(attributeModel);
        }

        @Override
        abstract T toScalarValue(@NonNull FileUpload var1);

        @Override
        protected final T toScalarValue(@Nullable List<FileUpload> fileUploads) {
            if (fileUploads == null || fileUploads.isEmpty()) {
                return null;
            }
            FileUpload fileUpload = fileUploads.get(0);
            if (fileUpload == null) {
                return null;
            }
            return this.toScalarValue(fileUpload);
        }

        @Override
        protected final List<FileUpload> fromScalarValue(T t) {
            return t != null ? Collections.emptyList() : null;
        }
    }
}

