/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models.interaction.act;

import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.facets.object.value.CompositeValueUpdater;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteraction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.interactions.managed.MultiselectChoices;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.interactions.managed.PendingParamsSnapshot;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.models.ParameterModel;
import org.apache.causeway.viewer.wicket.model.models.PropertyModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.interaction.BookmarkedObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.HasBookmarkedOwnerAbstract;
import org.apache.causeway.viewer.wicket.model.models.interaction.act.UiParameterWkt;
import org.jspecify.annotations.Nullable;

public class ActionInteractionWkt
extends HasBookmarkedOwnerAbstract<ActionInteraction> {
    private static final long serialVersionUID = 1L;
    private final String memberId;
    private final Where where;
    private @Nullable ObjectAction actionMemento;
    private transient @Nullable ObjectAction objectAction;
    private Can<UiParameterWkt> childModels;
    private @Nullable PropertyModel associatedWithPropertyIfAny;
    private @Nullable ParameterModel associatedWithParameterIfAny;
    private @Nullable CollectionModel associatedWithCollectionIfAny;
    private transient ParameterNegotiationModel parameterNegotiationModel;
    private PendingParamsSnapshot pendingParamsSnapshot;

    public static ActionInteractionWkt forEntity(UiObjectWkt parentEntityModel, Identifier actionIdentifier, Where where, PropertyModel associatedWithPropertyIfAny, ParameterModel associatedWithParameterIfAny, CollectionModel associatedWithCollectionIfAny) {
        ObjectSpecification onwerSpec = parentEntityModel.getBookmarkedOwner().objSpec();
        Optional objectAction = onwerSpec.getAction(actionIdentifier.memberLogicalName());
        return new ActionInteractionWkt(parentEntityModel.bookmarkedObjectModel(), actionIdentifier.memberLogicalName(), where, objectAction, associatedWithPropertyIfAny, associatedWithParameterIfAny, associatedWithCollectionIfAny);
    }

    private ActionInteractionWkt(BookmarkedObjectWkt bookmarkedObject, String memberId, Where where, Optional<ObjectAction> objectAction, PropertyModel associatedWithPropertyIfAny, ParameterModel associatedWithParameterIfAny, CollectionModel associatedWithCollectionIfAny) {
        super(bookmarkedObject);
        this.memberId = memberId;
        this.where = where;
        this.setObjectAction(objectAction.orElse(null));
        this.associatedWithPropertyIfAny = associatedWithPropertyIfAny;
        this.associatedWithParameterIfAny = associatedWithParameterIfAny;
        this.associatedWithCollectionIfAny = associatedWithCollectionIfAny;
    }

    private void setObjectAction(ObjectAction objectAction) {
        this.objectAction = objectAction;
        this.actionMemento = objectAction != null && !(objectAction instanceof CompositeValueUpdater) ? objectAction : null;
    }

    protected ActionInteraction load() {
        if (this.associatedWithParameterIfAny != null) {
            int paramIndex = this.associatedWithParameterIfAny.getParameterIndex();
            return ActionInteraction.startAsBoundToParameter((ParameterNegotiationModel)this.associatedWithParameterIfAny.getParameterNegotiationModel(), (int)paramIndex, (String)this.memberId, (Where)this.where);
        }
        if (this.associatedWithCollectionIfAny != null) {
            return ActionInteraction.startWithMultiselect((ManagedObject)this.getBookmarkedOwner(), (String)this.memberId, (Where)this.where, (MultiselectChoices)this.associatedWithCollectionIfAny.getDataTableModel());
        }
        if (this.associatedWithPropertyIfAny != null) {
            return ActionInteraction.startAsBoundToProperty((ManagedProperty)this.associatedWithPropertyIfAny.getManagedProperty(), (String)this.memberId, (Where)this.where);
        }
        return ActionInteraction.start((ManagedObject)this.getBookmarkedOwner(), (String)this.memberId, (Where)this.where);
    }

    public final ActionInteraction actionInteraction() {
        return (ActionInteraction)this.getObject();
    }

    public final ObjectAction getMetaModel() {
        if (this.objectAction != null) {
            return this.objectAction;
        }
        if (this.actionMemento != null) {
            return this.actionMemento;
        }
        this.setObjectAction(this.actionInteraction().getObjectActionElseFail());
        return this.objectAction;
    }

    public Optional<PropertyModel> associatedWithProperty() {
        return Optional.ofNullable(this.associatedWithPropertyIfAny);
    }

    public Optional<ParameterModel> associatedWithParameter() {
        return Optional.ofNullable(this.associatedWithParameterIfAny);
    }

    public Optional<CollectionModel> associatedWithCollection() {
        return Optional.ofNullable(this.associatedWithCollectionIfAny);
    }

    public Stream<UiParameterWkt> streamParameterUiModels() {
        if (this.childModels == null) {
            int paramCount = this.getMetaModel().getParameterCount();
            this.childModels = (Can)IntStream.range(0, paramCount).mapToObj(paramIndex -> new UiParameterWkt(this, paramIndex)).collect(Can.toCan());
        }
        return this.childModels.stream();
    }

    public final ParameterNegotiationModel parameterNegotiationModel() {
        this.guardAgainstNotAttached();
        if (this.parameterNegotiationModel != null) {
            ManagedObjects.stream((Can)this.parameterNegotiationModel.getParamValues()).forEach(domainObj -> ManagedObjects.refreshViewmodel((ManagedObject)domainObj, null));
            return this.parameterNegotiationModel;
        }
        if (PendingParamsSnapshot.canRestore((PendingParamsSnapshot)this.pendingParamsSnapshot)) {
            this.parameterNegotiationModel = this.pendingParamsSnapshot.restoreParameterNegotiationModel((ManagedAction)this.actionInteraction().getManagedAction().orElseThrow(() -> _Exceptions.noSuchElement((String)this.memberId)));
            return this.parameterNegotiationModel;
        }
        return this.startParameterNegotiationModel();
    }

    public void resetParametersToDefault() {
        this.parameterNegotiationModel = null;
        this.pendingParamsSnapshot = null;
    }

    public InlinePromptContext getInlinePromptContext() {
        return this.associatedWithPropertyIfAny != null ? this.associatedWithPropertyIfAny.getInlinePromptContext() : (this.associatedWithParameterIfAny != null ? this.associatedWithParameterIfAny.getInlinePromptContext() : null);
    }

    private ParameterNegotiationModel startParameterNegotiationModel() {
        Optional<MultiselectChoices> tableModel = this.actionInteraction().getManagedAction().map(ManagedAction::getMultiselectChoices);
        if (tableModel != null) {
            this.detach();
        }
        this.parameterNegotiationModel = (ParameterNegotiationModel)this.actionInteraction().startParameterNegotiation().orElseThrow(() -> _Exceptions.noSuchElement((String)this.memberId));
        this.pendingParamsSnapshot = this.parameterNegotiationModel.createSnapshotModel();
        return this.parameterNegotiationModel;
    }

    private void guardAgainstNotAttached() {
        if (!this.isAttached()) {
            this.resetParametersToDefault();
            this.getObject();
        }
        _Assert.assertTrue((boolean)this.isAttached(), () -> "model is not attached");
    }
}

