/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models.interaction.prop;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.interactions.managed.PropertyInteraction;
import org.apache.causeway.core.metamodel.interactions.managed.PropertyNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.wicket.model.models.interaction.BookmarkedObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.HasBookmarkedOwnerAbstract;
import org.apache.causeway.viewer.wicket.model.models.interaction.prop.UiPropertyWkt;

public class PropertyInteractionWkt
extends HasBookmarkedOwnerAbstract<PropertyInteraction> {
    private static final long serialVersionUID = 1L;
    private final String memberId;
    private final Where where;
    private Can<UiPropertyWkt> childModels;
    private transient _Lazy<Optional<PropertyNegotiationModel>> propertyNegotiationModel;

    public PropertyInteractionWkt(BookmarkedObjectWkt bookmarkedObject, String memberId, Where where) {
        super(bookmarkedObject);
        this.memberId = memberId;
        this.where = where;
    }

    protected PropertyInteraction load() {
        this.propertyNegotiationModel = _Lazy.threadSafe(this::startPropertyNegotiation);
        return this.loadPropertyInteraction();
    }

    public void detach() {
        super.detach();
        this.propertyNegotiationModel.clear();
    }

    public final PropertyInteraction propertyInteraction() {
        return (PropertyInteraction)this.getObject();
    }

    public Stream<UiPropertyWkt> streamPropertyUiModels() {
        if (this.childModels == null) {
            this.childModels = Can.ofSingleton((Object)new UiPropertyWkt(this));
        }
        return this.childModels.stream();
    }

    public final PropertyNegotiationModel propertyNegotiationModel() {
        this.guardAgainstNotAttached();
        return (PropertyNegotiationModel)((Optional)this.propertyNegotiationModel.get()).orElseThrow(() -> _Exceptions.noSuchElement((String)this.memberId));
    }

    public void resetPropertyToDefault() {
        this.propertyNegotiationModel.clear();
    }

    private Optional<PropertyNegotiationModel> startPropertyNegotiation() {
        PropertyInteraction propIa = this.propertyInteraction();
        ManagedProperty prop = (ManagedProperty)propIa.getManagedProperty().orElseThrow();
        ManagedObjects.refreshViewmodel((ManagedObject)prop.getOwner(), null);
        return propIa.startPropertyNegotiation();
    }

    private PropertyInteraction loadPropertyInteraction() {
        return PropertyInteraction.wrap((ManagedProperty)((ManagedProperty)ManagedProperty.lookupProperty((ManagedObject)this.getBookmarkedOwner(), (String)this.memberId, (Where)this.where).orElseThrow(() -> _Exceptions.noSuchElement((String)"property '%s' in %s", (Object[])new Object[]{this.memberId, this.getBookmarkedOwner().objSpec()}))));
    }

    private void guardAgainstNotAttached() {
        if (!this.isAttached()) {
            this.getObject();
        }
        _Assert.assertTrue((boolean)this.isAttached(), () -> "model is not attached");
    }
}

