/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.net.URL;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.applib.value.LocalResourcePath;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.PackedManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.FormExecutor;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.jspecify.annotations.NonNull;

public record ActionResultModel(FormExecutor.ActionResultResponseType responseType, ManagedObject resultAdapter) {
    public static ActionResultModel determineFor(@NonNull ActionModel actionModel, ManagedObject resultAdapter, AjaxRequestTarget targetIfAny) {
        if (actionModel.columnActionModifier().isForceStayOnPage()) {
            return new ActionResultModel(FormExecutor.ActionResultResponseType.RELOAD, resultAdapter);
        }
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)resultAdapter)) {
            return new ActionResultModel(FormExecutor.ActionResultResponseType.VOID_AS_EMPTY, resultAdapter);
        }
        ObjectSpecification resultSpec = resultAdapter.objSpec();
        if (!(resultAdapter instanceof PackedManagedObject)) {
            _Assert.assertTrue((boolean)resultSpec.isSingular());
            if ("causeway.security.LoginRedirect".equals(resultSpec.logicalTypeName())) {
                return new ActionResultModel(FormExecutor.ActionResultResponseType.SIGN_IN, resultAdapter);
            }
            if (resultSpec.isValue()) {
                Object value = resultAdapter.getPojo();
                if (value instanceof Clob) {
                    return new ActionResultModel(FormExecutor.ActionResultResponseType.VALUE_CLOB, resultAdapter);
                }
                if (value instanceof Blob) {
                    return new ActionResultModel(FormExecutor.ActionResultResponseType.VALUE_BLOB, resultAdapter);
                }
                if (value instanceof LocalResourcePath) {
                    return targetIfAny != null ? new ActionResultModel(FormExecutor.ActionResultResponseType.VALUE_LOCALRESPATH_AJAX, resultAdapter) : new ActionResultModel(FormExecutor.ActionResultResponseType.VALUE_LOCALRESPATH_NOAJAX, resultAdapter);
                }
                if (value instanceof URL) {
                    return targetIfAny != null ? new ActionResultModel(FormExecutor.ActionResultResponseType.VALUE_URL_AJAX, resultAdapter) : new ActionResultModel(FormExecutor.ActionResultResponseType.VALUE_URL_NOAJAX, resultAdapter);
                }
                return new ActionResultModel(FormExecutor.ActionResultResponseType.VALUE, resultAdapter);
            }
            return new ActionResultModel(FormExecutor.ActionResultResponseType.OBJECT, resultAdapter);
        }
        PackedManagedObject packedAdapter = (PackedManagedObject)resultAdapter;
        Can unpacked = packedAdapter.unpack();
        int cardinality = unpacked.size();
        switch (cardinality) {
            case 1: {
                ManagedObject firstElement = (ManagedObject)unpacked.getFirstElseFail();
                return ActionResultModel.determineFor(actionModel, firstElement, targetIfAny);
            }
        }
        return new ActionResultModel(FormExecutor.ActionResultResponseType.COLLECTION, resultAdapter);
    }
}

