/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.viewer.wicket.model.models.BookmarkTreeNode;
import org.apache.causeway.viewer.wicket.model.models.BookmarkableModel;
import org.apache.causeway.viewer.wicket.model.models.ModelAbstract;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;

public class BookmarkedPagesModel
extends ModelAbstract<List<BookmarkTreeNode>> {
    private static final long serialVersionUID = 1L;
    private final List<BookmarkTreeNode> rootNodes = _Lists.newArrayList();

    public void bookmarkPage(BookmarkableModel bookmarkableModel) {
        Bookmark bookmark = bookmarkableModel.toBookmark().orElse(null);
        if (bookmark == null) {
            return;
        }
        BookmarkTreeNode matchingRootNode = this.matchRootNode(bookmarkableModel).orElse(null);
        if (matchingRootNode != null) {
            this.rootNodes.remove(matchingRootNode);
            this.rootNodes.add(0, matchingRootNode);
        } else if (bookmarkableModel.getBookmarkPolicy().isRoot()) {
            this.rootNodes.add(0, BookmarkTreeNode.newRoot(bookmark, bookmarkableModel));
        }
        BookmarkedPagesModel.trim(this.rootNodes, this.getMaxSize());
    }

    protected List<BookmarkTreeNode> load() {
        ArrayList depthFirstGraph = _Lists.newArrayList();
        ArrayList sortedNodes = _Lists.newArrayList(this.rootNodes);
        Collections.sort(sortedNodes);
        for (BookmarkTreeNode rootNode : sortedNodes) {
            rootNode.appendGraphTo(depthFirstGraph);
        }
        return depthFirstGraph;
    }

    public void clear() {
        this.rootNodes.clear();
    }

    public boolean isEmpty() {
        return this.rootNodes.isEmpty();
    }

    public void remove(BookmarkTreeNode rootNode) {
        this.rootNodes.remove(rootNode);
    }

    public void remove(UiObjectWkt objectModel) {
        Bookmark bookmark = objectModel.getOwnerBookmark();
        this.rootNodes.removeIf(node -> node.getBookmark().equals(bookmark));
    }

    private Optional<BookmarkTreeNode> matchRootNode(BookmarkableModel bookmarkableModel) {
        for (BookmarkTreeNode rootNode : this.rootNodes) {
            if (!rootNode.matches(bookmarkableModel)) continue;
            return Optional.of(rootNode);
        }
        return Optional.empty();
    }

    private int getMaxSize() {
        return this.getWicketViewerSettings().getBookmarkedPages().getMaxSize();
    }

    private static void trim(List<?> list, int requiredSize) {
        int numToRetain = Math.min(list.size(), requiredSize);
        list.retainAll(list.subList(0, numToRetain));
    }
}

