/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars;

import java.time.temporal.Temporal;
import java.util.Optional;
import org.apache.causeway.applib.value.semantics.TemporalCharacteristicsProvider;
import org.apache.causeway.applib.value.semantics.TemporalSupport;
import org.apache.causeway.core.metamodel.object.MmValueUtils;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.model.value.ConverterBasedOnValueSemantics;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldWithValueSemantics;
import org.apache.causeway.viewer.wicket.ui.components.scalars.datepicker.TemporalDecompositionModel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.datepicker.TextFieldWithDateTimePicker;
import org.apache.causeway.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.PropertyModel;

public class ScalarPanelTextFieldWithTemporalPicker<T extends Temporal>
extends ScalarPanelTextFieldWithValueSemantics<T> {
    private static final long serialVersionUID = 1L;
    private TemporalDecompositionModel<T> temporalDecomposition;

    public ScalarPanelTextFieldWithTemporalPicker(String id, ScalarModel scalarModel, Class<T> type) {
        super(id, scalarModel, type);
    }

    protected int getDateRenderAdjustDays() {
        return Facets.dateRenderAdjustDays((ObjectFeature)this.scalarModel().getMetaModel());
    }

    @Override
    protected final TextField<T> createTextField(String id) {
        ScalarModel scalarModel = this.scalarModel();
        this.temporalDecomposition = TemporalDecompositionModel.create(this.type, scalarModel, this.offsetCharacteristic(), (ConverterBasedOnValueSemantics)this.converterElseFail());
        TextFieldWithDateTimePicker<T> textField = new TextFieldWithDateTimePicker<T>(id, scalarModel.unwrapped(this.type), this.type, scalarModel.isRequired(), this.temporalDecomposition, this.temporalDecomposition.getEditingPattern());
        return this.installUpdateNotifier(textField);
    }

    @Override
    protected void onFormGroupCreated(FormGroup formGroup) {
        if (!this.scalarModel().isEditingMode()) {
            return;
        }
        MarkupContainer container = WktComponents.findById((MarkupContainer)formGroup, "container-scalarValue", MarkupContainer.class).orElse(null);
        if (container == null) {
            return;
        }
        switch (this.offsetCharacteristic()) {
            case OFFSET: {
                Wkt.dropDownChoiceWithAjaxUpdateAdd(container, "timeoffset", new PropertyModel(this.temporalDecomposition, "zoneOffset"), this.temporalSupport().getAvailableOffsets()).setRequired(true);
                break;
            }
            case ZONED: {
                Wkt.dropDownChoiceWithAjaxUpdateAdd(container, "timezone", new PropertyModel(this.temporalDecomposition, "zoneId"), this.temporalSupport().getAvailableZoneIds()).setRequired(true);
                break;
            }
        }
    }

    protected final TextField<T> getTextField() {
        return (TextField)this.getFormComponent();
    }

    @Override
    protected Optional<ScalarFragmentFactory.InputFragment> getInputFragmentType() {
        switch (this.offsetCharacteristic()) {
            case OFFSET: {
                return Optional.of(ScalarFragmentFactory.InputFragment.TEMPORAL_WITH_OFFSET);
            }
            case ZONED: {
                return Optional.of(ScalarFragmentFactory.InputFragment.TEMPORAL_WITH_ZONE);
            }
        }
        return Optional.of(ScalarFragmentFactory.InputFragment.TEMPORAL);
    }

    @Override
    protected void installScalarModelChangeBehavior() {
    }

    private TemporalSupport<?> temporalSupport() {
        return MmValueUtils.temporalSupportElseFail((ObjectFeature)this.scalarModel().getMetaModel(), (ObjectSpecification)this.scalarModel().getElementType());
    }

    private TemporalCharacteristicsProvider.OffsetCharacteristic offsetCharacteristic() {
        return this.temporalSupport().getOffsetCharacteristic();
    }

    private <X> TextField<X> installUpdateNotifier(TextField<X> textField) {
        textField.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                ScalarPanelTextFieldWithTemporalPicker.this.getScalarModelChangeDispatcher().notifyUpdate(target);
            }
        }});
        return textField;
    }
}

