/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars.markup;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.value.semantics.Renderer;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmValueUtils;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.commons.model.scalar.UiParameter;
import org.apache.causeway.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.markup._HighlightBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;

public class MarkupComponent
extends WebComponent {
    private static final long serialVersionUID = 1L;
    private final Options options;

    public MarkupComponent(String id, IModel<?> model, Options options) {
        super(id, model);
        this.options = options;
    }

    public MarkupComponent(String id, IModel<?> model) {
        this(id, model, Options.defaults());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.options.highlightBehavior().renderHead(response);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        CharSequence htmlContent = this.extractHtmlOrElse(this.getDefaultModelObject(), "");
        this.replaceComponentTagBody(markupStream, openTag, this.options.highlightBehavior().htmlContentPostProcess(htmlContent));
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    protected CharSequence extractHtmlOrElse(Object modelObject, String fallback) {
        if (modelObject == null) {
            return fallback;
        }
        if (modelObject instanceof ManagedObject) {
            ManagedObject adapter = (ManagedObject)modelObject;
            ObjectFeature feature = this.lookupObjectFeatureIn(this.getDefaultModel()).orElse(null);
            String asHtml = MmValueUtils.htmlStringForValueType((ObjectFeature)feature, (ManagedObject)adapter);
            return asHtml != null ? asHtml : fallback;
        }
        return modelObject.toString();
    }

    protected Optional<ObjectFeature> lookupObjectFeatureIn(IModel<?> model) {
        if (model instanceof ScalarPropertyModel) {
            return Optional.of(((ScalarPropertyModel)model).getMetaModel());
        }
        if (model instanceof UiParameter) {
            return Optional.of(((UiParameter)model).getMetaModel());
        }
        if (model instanceof ValueModel) {
            return Optional.ofNullable(((ValueModel)model).getActionModelHint()).map(act -> act.getAction());
        }
        return Optional.empty();
    }

    public static final class Options
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Renderer.SyntaxHighlighter syntaxHighlighter;

        public static Options defaults() {
            return Options.builder().build();
        }

        private _HighlightBehavior highlightBehavior() {
            return _HighlightBehavior.valueOf(this.getSyntaxHighlighter());
        }

        private static Renderer.SyntaxHighlighter $default$syntaxHighlighter() {
            return Renderer.SyntaxHighlighter.NONE;
        }

        Options(Renderer.SyntaxHighlighter syntaxHighlighter) {
            this.syntaxHighlighter = syntaxHighlighter;
        }

        public static OptionsBuilder builder() {
            return new OptionsBuilder();
        }

        public Renderer.SyntaxHighlighter getSyntaxHighlighter() {
            return this.syntaxHighlighter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            Renderer.SyntaxHighlighter this$syntaxHighlighter = this.getSyntaxHighlighter();
            Renderer.SyntaxHighlighter other$syntaxHighlighter = other.getSyntaxHighlighter();
            return !(this$syntaxHighlighter == null ? other$syntaxHighlighter != null : !this$syntaxHighlighter.equals(other$syntaxHighlighter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Renderer.SyntaxHighlighter $syntaxHighlighter = this.getSyntaxHighlighter();
            result = result * 59 + ($syntaxHighlighter == null ? 43 : $syntaxHighlighter.hashCode());
            return result;
        }

        public String toString() {
            return "MarkupComponent.Options(syntaxHighlighter=" + this.getSyntaxHighlighter() + ")";
        }

        public static class OptionsBuilder {
            private boolean syntaxHighlighter$set;
            private Renderer.SyntaxHighlighter syntaxHighlighter$value;

            OptionsBuilder() {
            }

            public OptionsBuilder syntaxHighlighter(Renderer.SyntaxHighlighter syntaxHighlighter) {
                this.syntaxHighlighter$value = syntaxHighlighter;
                this.syntaxHighlighter$set = true;
                return this;
            }

            public Options build() {
                Renderer.SyntaxHighlighter syntaxHighlighter$value = this.syntaxHighlighter$value;
                if (!this.syntaxHighlighter$set) {
                    syntaxHighlighter$value = Options.$default$syntaxHighlighter();
                }
                return new Options(syntaxHighlighter$value);
            }

            public String toString() {
                return "MarkupComponent.Options.OptionsBuilder(syntaxHighlighter$value=" + this.syntaxHighlighter$value + ")";
            }
        }
    }
}

