/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import java.io.Serializable;
import java.util.Objects;
import lombok.NonNull;
import org.apache.causeway.applib.graph.tree.TreePath;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmUnwrapUtils;
import org.apache.causeway.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.springframework.lang.Nullable;

class _TreeNodeMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Bookmark bookmark;
    private final TreePath treePath;
    private final int hashCode;

    public _TreeNodeMemento(@NonNull TreePath treePath) {
        if (treePath == null) {
            throw new NullPointerException("treePath is marked non-null but is null");
        }
        this.bookmark = null;
        this.treePath = treePath;
        this.hashCode = Objects.hash(0, treePath.hashCode());
    }

    public _TreeNodeMemento(@NonNull TreePath treePath, @NonNull Bookmark bookmark) {
        if (treePath == null) {
            throw new NullPointerException("treePath is marked non-null but is null");
        }
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        this.bookmark = bookmark;
        this.treePath = treePath;
        this.hashCode = Objects.hash(bookmark.hashCode(), treePath.hashCode());
    }

    public boolean isTreePathMemento() {
        return this.bookmark == null;
    }

    @Nullable
    public Object getPojo() {
        return MmUnwrapUtils.single((ManagedObject)((ManagedObject)this.asObjectAdapterModel().getObject()));
    }

    public ObjectAdapterModel asObjectAdapterModel() {
        _Assert.assertFalse((boolean)this.isTreePathMemento());
        return UiObjectWkt.ofBookmark((Bookmark)this.getBookmark());
    }

    public boolean equals(Object obj) {
        if (obj instanceof _TreeNodeMemento) {
            _TreeNodeMemento other = (_TreeNodeMemento)obj;
            return this.treePath.equals(other.treePath) && this.bookmark.equals(other.bookmark);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }
}

