/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages;

import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.config.viewer.web.WebAppContextPath;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.MetaDataHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class WebPageBase
extends WebPage
implements HasCommonContext {
    private static final long serialVersionUID = 1L;
    private transient PageClassRegistry pageClassRegistry;

    protected WebPageBase(PageParameters parameters) {
        super(parameters);
    }

    protected WebPageBase(IModel<?> model) {
        super(model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.renderFavicon(response);
    }

    protected void renderFavicon(IHeaderResponse response) {
        this.getApplicationSettings().getFaviconUrl().filter(_Strings::isNotEmpty).map(arg_0 -> ((WebAppContextPath)this.getWebAppContextPath()).prependContextPathIfLocal(arg_0)).ifPresent(faviconUrl -> response.render((HeaderItem)MetaDataHeaderItem.forLinkTag((String)"icon", (String)faviconUrl)));
    }

    public PageClassRegistry getPageClassRegistry() {
        this.pageClassRegistry = this.computeIfAbsent(PageClassRegistry.class, this.pageClassRegistry);
        return this.pageClassRegistry;
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : this.getMetaModelContext().lookupServiceElseFail(type));
    }
}

