/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.accmngt;

import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.userreg.UserRegistrationService;
import org.apache.causeway.viewer.wicket.ui.validation.ValidatorBase;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;

public class UsernameAvailableValidator
extends ValidatorBase<String> {
    private static final long serialVersionUID = 1L;

    public static UsernameAvailableValidator newInstance() {
        return new UsernameAvailableValidator();
    }

    public void validate(IValidatable<String> validatable) {
        UserRegistrationService userRegistrationService = (UserRegistrationService)super.getMetaModelContext().lookupServiceElseFail(UserRegistrationService.class);
        InteractionService interactionService = (InteractionService)super.getMetaModelContext().lookupServiceElseFail(InteractionService.class);
        interactionService.runAnonymous(() -> {
            String username = (String)validatable.getValue();
            boolean usernameExists = userRegistrationService.usernameExists(username);
            if (usernameExists) {
                validatable.error((IValidationError)new ValidationError().addKey("usernameIsNotAvailable"));
            }
        });
    }
}

