/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.bookmarkedpages;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.causeway.applib.exceptions.unrecoverable.ObjectNotFoundException;
import org.apache.causeway.viewer.wicket.model.models.BookmarkTreeNode;
import org.apache.causeway.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class BookmarkedPagesPanel
extends PanelAbstract<List<BookmarkTreeNode>, BookmarkedPagesModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BOOKMARK_LIST = "bookmarkList";
    private static final String ID_BOOKMARKS_HELP_TEXT = "helpText";
    private static final String ID_BOOKMARKED_PAGE_LINK = "bookmarkedPageLink";
    private static final String ID_CLEAR_BOOKMARK_LINK = "clearBookmarkLink";
    private static final String ID_BOOKMARKED_PAGE_ITEM = "bookmarkedPageItem";
    private static final String ID_BOOKMARKED_PAGE_TITLE = "bookmarkedPageTitle";
    private static final String ID_BOOKMARKED_PAGE_ICON = "bookmarkedPageImage";
    private static final String ID_BOOKMARKED_PAGE_ICON_FA = "bookmarkedPageFontAwesome";
    private static final String CLEAR_BOOKMARKS = "clearBookmarks";
    private static final JavaScriptResourceReference SLIDE_PANEL_JS = new JavaScriptResourceReference(BookmarkedPagesPanel.class, "slide-panel.js");
    @Inject
    private PageClassRegistry pageClassRegistry;

    public BookmarkedPagesPanel(String id, BookmarkedPagesModel bookmarkedPagesModel) {
        super(id, bookmarkedPagesModel);
        this.buildGui();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
    }

    private void buildGui() {
        BookmarkedPagesModel bookmarkedPagesModel = (BookmarkedPagesModel)this.getModel();
        Component helpText = this.addHelpText(bookmarkedPagesModel);
        this.addOrReplace(new Component[]{helpText});
        WebMarkupContainer container = new WebMarkupContainer(ID_BOOKMARK_LIST){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(BookmarkedPagesPanel.class, "BookmarkedPagesPanel.css")));
                response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)SLIDE_PANEL_JS));
            }
        };
        Wkt.ajaxEnable(this);
        Wkt.ajaxEnable(container);
        this.add(new Component[]{container});
        AjaxLinkNoPropagate clearAllBookmarksLink = Wkt.linkAdd((MarkupContainer)this, CLEAR_BOOKMARKS, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
            ((BookmarkedPagesModel)this.getModel()).clear();
            this.setEnabled(false);
            target.add(new Component[]{container, this});
        });
        clearAllBookmarksLink.setOutputMarkupId(true);
        if (((BookmarkedPagesModel)this.getModel()).isEmpty()) {
            clearAllBookmarksLink.setVisible(false);
        }
        Wkt.listViewAdd((MarkupContainer)container, ID_BOOKMARKED_PAGE_ITEM, bookmarkedPagesModel, (SerializableConsumer & Serializable)item -> {
            BookmarkTreeNode bookmarkNode = (BookmarkTreeNode)item.getModelObject();
            try {
                Class<? extends Page> pageClass = this.pageClassRegistry.getPageClass(PageType.ENTITY);
                AjaxLinkNoPropagate clearBookmarkLink = Wkt.linkAdd((MarkupContainer)item, ID_CLEAR_BOOKMARK_LINK, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                    bookmarkedPagesModel.remove(bookmarkNode);
                    if (bookmarkedPagesModel.isEmpty()) {
                        WktComponents.permanentlyHide((MarkupContainer)this, CLEAR_BOOKMARKS);
                    }
                    target.add(new Component[]{container, clearAllBookmarksLink});
                });
                if (bookmarkNode.getDepth() == 0) {
                    Wkt.cssAppend(clearBookmarkLink, "clearBookmark");
                } else {
                    clearBookmarkLink.setEnabled(true);
                }
                AbstractLink link = Wkt.add((MarkupContainer)item, WktLinks.newBookmarkablePageLink(ID_BOOKMARKED_PAGE_LINK, bookmarkNode.getPageParameters(), pageClass));
                bookmarkNode.eitherIconOrFaClass().accept(iconResourceRef -> {
                    Optional.ofNullable(iconResourceRef).ifPresent(icon -> Wkt.imageAddCachable((MarkupContainer)link, ID_BOOKMARKED_PAGE_ICON, icon));
                    WktComponents.permanentlyHide((MarkupContainer)link, ID_BOOKMARKED_PAGE_ICON_FA);
                }, faLayers -> {
                    WktComponents.permanentlyHide((MarkupContainer)link, ID_BOOKMARKED_PAGE_ICON);
                    Wkt.faIconLayersAdd((MarkupContainer)link, ID_BOOKMARKED_PAGE_ICON_FA, faLayers);
                });
                Wkt.labelAdd((MarkupContainer)link, ID_BOOKMARKED_PAGE_TITLE, bookmarkNode.getTitle());
                Wkt.cssAppend(item, "bookmarkDepth" + bookmarkNode.getDepth());
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        });
    }

    protected Component addHelpText(final BookmarkedPagesModel bookmarkedPagesModel) {
        IModel<String> helpTextModel = new IModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return bookmarkedPagesModel.isEmpty() ? "You have no bookmarks!" : "";
            }
        };
        Label helpText = new Label(ID_BOOKMARKS_HELP_TEXT, (IModel)helpTextModel){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!Strings.isEmpty((String)this.getDefaultModelObjectAsString()));
            }
        };
        helpText.setOutputMarkupPlaceholderTag(true);
        return helpText;
    }
}

