/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.nav.pagesize;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.viewer.wicket.model.pagesize.PagesizeChoice;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class PagesizeChooser
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTRIES_PER_PAGE_LABEL = "entriesPerPageLabel";
    private static final String ID_PAGESIZE_CHOICE = "pagesizeChoice";
    private static final String ID_PAGESIZE_CHOICES = "pagesizeChoices";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    private static final String ID_VIEW_ITEM_CHECKMARK = "viewItemCheckmark";
    final DataTableWithPagesAndFilter<?, ?> table;

    public PagesizeChooser(String id, DataTableWithPagesAndFilter<?, ?> table) {
        super(id);
        this.table = table;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        Wkt.labelAdd((MarkupContainer)this, ID_ENTRIES_PER_PAGE_LABEL, this.table.getEntriesPerPageAsLiteral());
        Wkt.listViewAdd((MarkupContainer)this, ID_PAGESIZE_CHOICES, this.table.getPagesizeChoices(), (SerializableConsumer & Serializable)item -> {
            AjaxLinkNoPropagate link = Wkt.linkAdd((MarkupContainer)item, ID_PAGESIZE_CHOICE, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                PagesizeChoice pagesizeChoice = (PagesizeChoice)item.getModelObject();
                this.table.setItemsPerPage(pagesizeChoice.getItemsPerPage());
                this.table.setPageSizeHintAndBroadcast((AjaxRequestTarget)target);
                target.add(new Component[]{this.table});
            });
            PagesizeChooser.addIconAndTitle((ListItem<PagesizeChoice>)item, link);
            PagesizeChooser.addCheckmark((ListItem<PagesizeChoice>)item, link, this.table.getCurrentPagesizeChoice());
            Wkt.ajaxEnable(link);
        });
    }

    private static void addIconAndTitle(@NonNull ListItem<PagesizeChoice> item, @NonNull AjaxLinkNoPropagate link) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (link == null) {
            throw new NullPointerException("link is marked non-null but is null");
        }
        WktLinks.listItemAsDropdownLink(item, link, ID_VIEW_ITEM_TITLE, pagesizeChoice -> Model.of((Serializable)((Object)pagesizeChoice.getTitle())), ID_VIEW_ITEM_ICON, pagesizeChoice -> Model.of((Serializable)((Object)pagesizeChoice.getCssClass())), null);
    }

    private static void addCheckmark(@NonNull ListItem<PagesizeChoice> item, @NonNull AjaxLinkNoPropagate link, @NonNull Optional<PagesizeChoice> currentPagesizeChoice) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (link == null) {
            throw new NullPointerException("link is marked non-null but is null");
        }
        if (currentPagesizeChoice == null) {
            throw new NullPointerException("currentPagesizeChoice is marked non-null but is null");
        }
        Label checkmarkForChoice = Wkt.labelAdd((MarkupContainer)link, ID_VIEW_ITEM_CHECKMARK, "");
        Boolean isSelected = currentPagesizeChoice.map(currentChoice -> currentChoice.equals(item.getModelObject())).orElse(false);
        checkmarkForChoice.setVisible(isSelected.booleanValue());
        if (isSelected.booleanValue()) {
            link.setEnabled(false);
        }
    }

    @Generated
    public DataTableWithPagesAndFilter<?, ?> getTable() {
        return this.table;
    }
}

