/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.LabelPosition;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.debug._Probe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.commons.model.decorators.FormLabelDecorator;
import org.apache.causeway.viewer.commons.model.scalar.UiParameter;
import org.apache.causeway.viewer.wicket.model.links.LinkAndLabel;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarModelChangeDispatcher;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarModelChangeListener;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarModelDefaultChangeBehavior;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelSelectAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars._Util;
import org.apache.causeway.viewer.wicket.ui.components.scalars._Xray;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public abstract class ScalarPanelAbstract
extends PanelAbstract<ManagedObject, ScalarModel>
implements ScalarModelChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final String ID_SCALAR_TYPE_CONTAINER = "scalarTypeContainer";
    protected static final String ID_SCALAR_NAME_BEFORE_VALUE = "scalarNameBeforeValue";
    protected static final String ID_SCALAR_NAME_AFTER_VALUE = "scalarNameAfterValue";
    protected static final String ID_SCALAR_VALUE = "scalarValue";
    protected static final String ID_XRAY_DETAILS = "xrayDetails";
    private final ImmutableEnumSet<FormatModifier> formatModifiers;
    private Component compactFrame;
    private MarkupContainer regularFrame;
    private WebMarkupContainer formFrame;
    private WebMarkupContainer scalarFrameContainer;
    private final RenderScenario renderScenario;
    private final ScalarModelChangeDispatcher scalarModelChangeDispatcher = new ScalarModelChangeDispatcherImpl(this);

    public final ScalarModel scalarModel() {
        return (ScalarModel)super.getModel();
    }

    protected void setupFormatModifiers(EnumSet<FormatModifier> modifiers) {
    }

    protected abstract Component createCompactFrame();

    protected abstract MarkupContainer createRegularFrame();

    protected final WebMarkupContainer getScalarFrameContainer() {
        return this.scalarFrameContainer;
    }

    protected ScalarPanelAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        EnumSet<FormatModifier> formatModifiers = EnumSet.noneOf(FormatModifier.class);
        this.setupFormatModifiers(formatModifiers);
        this.formatModifiers = ImmutableEnumSet.from(formatModifiers);
        this.renderScenario = RenderScenario.inferFrom(this);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
        this.callHooks();
        this.setOutputMarkupId(true);
    }

    public final String getCssClassName() {
        return _Strings.decapitalize((String)this.getClass().getSimpleName());
    }

    private void buildGui() {
        ScalarModel scalarModel = this.scalarModel();
        this.scalarFrameContainer = Wkt.containerAdd((MarkupContainer)this, ID_SCALAR_TYPE_CONTAINER);
        Wkt.cssAppend(this.scalarFrameContainer, this.getCssClassName());
        if (scalarModel.getRenderingHint().isInTable()) {
            this.regularFrame = this.createShallowRegularFrame();
            this.compactFrame = this.createCompactFrame();
            this.regularFrame.setVisible(false);
            this.compactFrame.setVisible(true);
            Component[] componentArray = new Component[3];
            componentArray[0] = this.compactFrame;
            componentArray[1] = this.regularFrame;
            this.formFrame = this.createFormFrame();
            componentArray[2] = this.formFrame;
            this.scalarFrameContainer.addOrReplace(componentArray);
        } else {
            this.regularFrame = Wkt.ajaxEnable(this.createRegularFrame());
            this.compactFrame = this.createShallowCompactFrame();
            this.regularFrame.setVisible(true);
            this.compactFrame.setVisible(false);
            Component[] componentArray = new Component[3];
            componentArray[0] = this.compactFrame;
            componentArray[1] = this.regularFrame;
            this.formFrame = this.createFormFrame();
            componentArray[2] = this.formFrame;
            this.scalarFrameContainer.addOrReplace(componentArray);
            Can<LinkAndLabel> associatedLinksAndLabels = _Util.associatedLinksAndLabels(scalarModel);
            this.addPositioningCssTo(this.regularFrame, associatedLinksAndLabels);
            this.addActionLinksBelowAndRight(this.regularFrame, associatedLinksAndLabels);
            this.addFeedbackOnlyTo(this.regularFrame, this.getValidationFeedbackReceiver());
            this.setupInlinePrompt();
        }
        if (_Util.isPropertyWithEnterEditNotAvailable(scalarModel)) {
            Wkt.noTabbing(this.getValidationFeedbackReceiver());
        }
        this.addCssFromMetaModel();
        this.addChangeListener(this);
        this.installScalarModelChangeBehavior();
    }

    protected abstract void setupInlinePrompt();

    protected MarkupContainer createShallowRegularFrame() {
        WebMarkupContainer shallowRegularFrame = ScalarFragmentFactory.FrameFragment.REGULAR.createComponent(Wkt::container);
        WktComponents.permanentlyHide((MarkupContainer)shallowRegularFrame, ID_SCALAR_NAME_BEFORE_VALUE, ID_SCALAR_VALUE, ID_SCALAR_NAME_AFTER_VALUE, ScalarFragmentFactory.RegularFrame.FIELD.getContainerId(), ScalarFragmentFactory.RegularFrame.FEEDBACK.getContainerId(), ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_BELOW.getContainerId(), ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_RIGHT.getContainerId());
        return shallowRegularFrame;
    }

    protected Component createShallowCompactFrame() {
        return ScalarFragmentFactory.FrameFragment.COMPACT.createComponent(Wkt::container);
    }

    protected WebMarkupContainer createFormFrame() {
        boolean isNotInTable = this.scalarModel().getRenderingHint().isNotInTable();
        return (WebMarkupContainer)ScalarFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.createComponent(WebMarkupContainer::new).setVisible(false).setOutputMarkupId(isNotInTable);
    }

    protected final void switchRegularFrameToFormFrame() {
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this.getScalarFrameContainer(), ScalarFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.getContainerId(), UiComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.scalarModel());
        this.getRegularFrame().setVisible(false);
        this.getFormFrame().setVisible(true);
    }

    private void callHooks() {
        ScalarModel scalarModel = this.scalarModel();
        if (scalarModel.disabledReason().isPresent()) {
            boolean isOrCanBeSwitchedToEditable;
            boolean bl = isOrCanBeSwitchedToEditable = scalarModel.isEditingMode() || scalarModel.isParameter() || scalarModel.hasAssociatedActionWithInlineAsIfEdit();
            if (isOrCanBeSwitchedToEditable) {
                this.onInitializeNotEditable();
            } else {
                String disabledReason = (String)scalarModel.disabledReason().flatMap(InteractionVeto::getReasonAsString).orElseThrow(() -> _Exceptions.unrecoverable((String)"framework bug: ScalarModel indicates it has a disabled-reason, yet its empty"));
                this.onInitializeReadonly(disabledReason);
            }
        } else if (scalarModel.isViewingMode()) {
            this.onInitializeNotEditable();
        } else {
            this.onInitializeEditable();
        }
    }

    protected void onInitializeNotEditable() {
    }

    protected void onInitializeReadonly(String disableReason) {
    }

    protected void onInitializeEditable() {
    }

    protected abstract void onMakeNotEditable(String var1);

    protected abstract void onMakeEditable();

    private void addCssFromMetaModel() {
        ScalarModel scalarModel = this.scalarModel();
        Wkt.cssAppend(this, scalarModel.getCssClass());
        Facets.cssClass((FacetHolder)scalarModel.getMetaModel(), (ManagedObject)scalarModel.getParentUiModel().getManagedObject()).ifPresent(cssClass -> Wkt.cssAppend(this, cssClass));
    }

    protected void onConfigure() {
        boolean hidden = this.scalarModel().whetherHidden();
        this.setVisibilityAllowed(!hidden);
        super.onConfigure();
    }

    protected void installScalarModelChangeBehavior() {
        this.addOrReplaceBehavoir(ScalarModelDefaultChangeBehavior.class, () -> new ScalarModelDefaultChangeBehavior(this));
    }

    public void addChangeListener(ScalarModelChangeListener listener) {
        ((ScalarModelChangeDispatcherImpl)this.getScalarModelChangeDispatcher()).addChangeListener(listener);
    }

    protected final <T extends Behavior> void addOrReplaceBehavoir(@NonNull Class<T> behaviorClass, @NonNull Supplier<T> factory) {
        if (behaviorClass == null) {
            throw new NullPointerException("behaviorClass is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        Component validationFeedbackReceiver = this.getValidationFeedbackReceiver();
        if (validationFeedbackReceiver == null) {
            return;
        }
        for (Behavior behavior : validationFeedbackReceiver.getBehaviors(behaviorClass)) {
            validationFeedbackReceiver.remove(new Behavior[]{behavior});
        }
        validationFeedbackReceiver.add(new Behavior[]{(Behavior)factory.get()});
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
        if (((ScalarModel)this.getModel()).isParameter()) {
            Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
        }
    }

    @Override
    public void onError(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
    }

    protected final void scalarNameLabelAddTo(MarkupContainer container, IModel<String> labelCaption) {
        ScalarModel scalarModel = this.scalarModel();
        ScalarNameHelper helper = ScalarNameHelper.from(scalarModel);
        helper.hideHiddenLabels(container);
        helper.visibleLabelId.ifPresent(visibleLabelId -> {
            Label scalarNameLabel = Wkt.labelAdd(container, visibleLabelId, labelCaption);
            if (_Strings.isNullOrEmpty((CharSequence)((CharSequence)labelCaption.getObject()))) {
                return;
            }
            WktDecorators.getFormLabel().decorate((Component)scalarNameLabel, FormLabelDecorator.FormLabelDecorationModel.mandatory((boolean)scalarModel.isShowMandatoryIndicator()));
            scalarModel.getDescribedAs().ifPresent(describedAs -> WktTooltips.addTooltip(scalarNameLabel, describedAs));
        });
    }

    @Nullable
    protected abstract Component getValidationFeedbackReceiver();

    private void addFeedbackOnlyTo(MarkupContainer markupContainer, Component component) {
        if (component == null) {
            return;
        }
        markupContainer.addOrReplace(new Component[]{ScalarFragmentFactory.RegularFrame.FEEDBACK.createComponent(id -> new NotificationPanel(id, component, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(component)))});
    }

    private void addActionLinksBelowAndRight(MarkupContainer labelIfRegular, Can<LinkAndLabel> linkAndLabels) {
        Can linksBelow = linkAndLabels.filter(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.BELOW));
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_BELOW.getContainerId(), (Can<LinkAndLabel>)linksBelow, AdditionalLinksPanel.Style.INLINE_LIST);
        Can linksRight = linkAndLabels.filter(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT));
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ScalarFragmentFactory.RegularFrame.ASSOCIATED_ACTION_LINKS_RIGHT.getContainerId(), (Can<LinkAndLabel>)linksRight, AdditionalLinksPanel.Style.DROPDOWN);
    }

    private void addPositioningCssTo(MarkupContainer markupContainer, Can<LinkAndLabel> actionLinks) {
        Wkt.cssAppend(markupContainer, ScalarPanelAbstract.determinePropParamLayoutCss((ScalarModel)this.getModel()));
        Wkt.cssAppend(markupContainer, ScalarPanelAbstract.determineActionLayoutPositioningCss(actionLinks));
    }

    private static String determinePropParamLayoutCss(ScalarModel scalarModel) {
        return Facets.labelAtCss((ObjectFeature)scalarModel.getMetaModel());
    }

    private static String determineActionLayoutPositioningCss(Can<LinkAndLabel> entityActionLinks) {
        return entityActionLinks.stream().anyMatch(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT)) ? "actions-right" : null;
    }

    public Repaint updateIfNecessary(@NonNull UiParameter paramModel) {
        if (paramModel == null) {
            throw new NullPointerException("paramModel is marked non-null but is null");
        }
        boolean visibilityBefore = this.isVisibilityAllowed();
        Consent visibilityConsent = paramModel.getParameterNegotiationModel().getVisibilityConsent(paramModel.getParameterIndex());
        boolean visibilityAfter = visibilityConsent.isAllowed();
        this.setVisibilityAllowed(visibilityAfter);
        boolean usabilityBefore = this.isEnabled();
        Consent usabilityConsent = paramModel.getParameterNegotiationModel().getUsabilityConsent(paramModel.getParameterIndex());
        boolean usabilityAfter = usabilityConsent.isAllowed();
        if (usabilityAfter) {
            this.onMakeEditable();
        } else {
            this.onMakeNotEditable(usabilityConsent.getReasonAsString().orElse(null));
        }
        if (visibilityBefore != visibilityAfter) {
            return visibilityAfter ? Repaint.REQUIRED_ON_PARENT : Repaint.REQUIRED;
        }
        if (usabilityBefore != usabilityAfter && visibilityAfter) {
            return Repaint.REQUIRED;
        }
        return Repaint.OPTIONAL;
    }

    public ImmutableEnumSet<FormatModifier> getFormatModifiers() {
        return this.formatModifiers;
    }

    protected Component getCompactFrame() {
        return this.compactFrame;
    }

    protected MarkupContainer getRegularFrame() {
        return this.regularFrame;
    }

    protected WebMarkupContainer getFormFrame() {
        return this.formFrame;
    }

    protected RenderScenario getRenderScenario() {
        return this.renderScenario;
    }

    public ScalarModelChangeDispatcher getScalarModelChangeDispatcher() {
        return this.scalarModelChangeDispatcher;
    }

    static class ScalarModelChangeDispatcherImpl
    implements ScalarModelChangeDispatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<ScalarModelChangeListener> changeListeners = _Lists.newArrayList();
        private final ScalarPanelAbstract scalarPanel;

        @Override
        public void notifyUpdate(AjaxRequestTarget target) {
            _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User either having changed a Property value during inline editing or having changed a Parameter value within an open ActionPrompt.");
            _Xray.onParamOrPropertyEdited(this.scalarPanel);
            ScalarModelChangeDispatcher.super.notifyUpdate(target);
        }

        @Override
        @NonNull
        public Iterable<ScalarModelChangeListener> getChangeListeners() {
            return Collections.unmodifiableCollection(this.changeListeners);
        }

        void addChangeListener(ScalarModelChangeListener listener) {
            this.changeListeners.add(listener);
        }

        public ScalarModelChangeDispatcherImpl(ScalarPanelAbstract scalarPanel) {
            this.scalarPanel = scalarPanel;
        }

        @Override
        public ScalarPanelAbstract getScalarPanel() {
            return this.scalarPanel;
        }
    }

    public static enum FormatModifier {
        MARKUP,
        MULTILINE,
        TEXT_ONLY;

    }

    public static enum RenderScenario {
        COMPACT,
        READONLY,
        CAN_EDIT,
        CAN_EDIT_INLINE,
        CAN_EDIT_INLINE_VIA_ACTION,
        EDITING,
        EDITING_WITH_LINK_TO_NESTED;


        public boolean isCompact() {
            return this == COMPACT;
        }

        public boolean isReadonly() {
            return this == READONLY;
        }

        public boolean isCanEdit() {
            return this == CAN_EDIT;
        }

        public boolean isEditing() {
            return this == EDITING;
        }

        public boolean isEditingAny() {
            return this == EDITING || this == CAN_EDIT_INLINE_VIA_ACTION;
        }

        public boolean isViewingAndCanEditAny() {
            return this == CAN_EDIT || this == CAN_EDIT_INLINE || this == CAN_EDIT_INLINE_VIA_ACTION;
        }

        static RenderScenario inferFrom(ScalarPanelAbstract scalarPanel) {
            ScalarModel scalarModel = scalarPanel.scalarModel();
            if (scalarModel.getRenderingHint().isInTable()) {
                return COMPACT;
            }
            if (scalarModel.isParameter() && !(scalarPanel instanceof ScalarPanelSelectAbstract) && scalarModel.disabledReason().isPresent()) {
                return READONLY;
            }
            if (scalarModel.isEditingMode()) {
                return _Util.canParameterEnterNestedEdit(scalarModel) ? EDITING_WITH_LINK_TO_NESTED : EDITING;
            }
            if (_Util.canPropertyEnterInlineEditDirectly(scalarModel)) {
                return CAN_EDIT_INLINE;
            }
            if (_Util.lookupPropertyActionForInlineEdit(scalarModel).isPresent()) {
                return CAN_EDIT_INLINE_VIA_ACTION;
            }
            return scalarModel.disabledReason().isPresent() ? READONLY : CAN_EDIT;
        }
    }

    private static final class ScalarNameHelper {
        private final Optional<String> visibleLabelId;
        private final String[] hiddenLabelIds;

        static ScalarNameHelper from(ScalarModel scalarModel) {
            LabelPosition labelPostion = Facets.labelAt((ObjectFeature)scalarModel.getMetaModel());
            return labelPostion == LabelPosition.NONE ? new ScalarNameHelper(Optional.empty(), new String[]{ScalarPanelAbstract.ID_SCALAR_NAME_BEFORE_VALUE, ScalarPanelAbstract.ID_SCALAR_NAME_AFTER_VALUE}) : (labelPostion == LabelPosition.RIGHT ? new ScalarNameHelper(Optional.of(ScalarPanelAbstract.ID_SCALAR_NAME_AFTER_VALUE), new String[]{ScalarPanelAbstract.ID_SCALAR_NAME_BEFORE_VALUE}) : new ScalarNameHelper(Optional.of(ScalarPanelAbstract.ID_SCALAR_NAME_BEFORE_VALUE), new String[]{ScalarPanelAbstract.ID_SCALAR_NAME_AFTER_VALUE}));
        }

        void hideHiddenLabels(MarkupContainer container) {
            for (String hiddenLabelId : this.hiddenLabelIds) {
                WktComponents.permanentlyHide(container, hiddenLabelId);
            }
        }

        public ScalarNameHelper(Optional<String> visibleLabelId, String[] hiddenLabelIds) {
            this.visibleLabelId = visibleLabelId;
            this.hiddenLabelIds = hiddenLabelIds;
        }

        public Optional<String> getVisibleLabelId() {
            return this.visibleLabelId;
        }

        public String[] getHiddenLabelIds() {
            return this.hiddenLabelIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScalarNameHelper)) {
                return false;
            }
            ScalarNameHelper other = (ScalarNameHelper)o;
            Optional<String> this$visibleLabelId = this.getVisibleLabelId();
            Optional<String> other$visibleLabelId = other.getVisibleLabelId();
            if (this$visibleLabelId == null ? other$visibleLabelId != null : !((Object)this$visibleLabelId).equals(other$visibleLabelId)) {
                return false;
            }
            return Arrays.deepEquals(this.getHiddenLabelIds(), other.getHiddenLabelIds());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $visibleLabelId = this.getVisibleLabelId();
            result = result * 59 + ($visibleLabelId == null ? 43 : ((Object)$visibleLabelId).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getHiddenLabelIds());
            return result;
        }

        public String toString() {
            return "ScalarPanelAbstract.ScalarNameHelper(visibleLabelId=" + this.getVisibleLabelId() + ", hiddenLabelIds=" + Arrays.deepToString(this.getHiddenLabelIds()) + ")";
        }
    }

    public static enum Repaint {
        OPTIONAL,
        REQUIRED,
        REQUIRED_ON_PARENT;


        public static Repaint required(boolean needsRepainting) {
            return needsRepainting ? REQUIRED : OPTIONAL;
        }

        public boolean isOptional() {
            return this == OPTIONAL;
        }

        public boolean isRequired() {
            return this == REQUIRED;
        }

        public boolean isRequiredOnParent() {
            return this == REQUIRED_ON_PARENT;
        }

        public Repaint max(@NonNull Repaint other) {
            if (other == null) {
                throw new NullPointerException("other is marked non-null but is null");
            }
            return this.ordinal() >= other.ordinal() ? this : other;
        }
    }
}

