/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionmenu.entityactions;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.viewer.wicket.model.links.LinkAndLabel;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksAsDropDownPanel;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksAsListInlinePanel;
import org.apache.causeway.viewer.wicket.ui.components.menuable.MenuablePanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class AdditionalLinksPanel
extends MenuablePanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ADDITIONAL_LINK_LIST = "additionalLinkList";
    private static final String ID_ADDITIONAL_LINK_ITEM = "additionalLinkItem";
    private static final String ID_ADDITIONAL_LINK_TITLE = "additionalLinkTitle";
    public static final String ID_ADDITIONAL_LINK = "additionalLink";

    public static AdditionalLinksPanel addAdditionalLinks(MarkupContainer markupContainer, String id, Can<LinkAndLabel> links, Style style) {
        if (links.isEmpty()) {
            WktComponents.permanentlyHide(markupContainer, id);
            return null;
        }
        return Wkt.add(markupContainer, style.newPanel(id, links));
    }

    protected AdditionalLinksPanel(String id, Can<LinkAndLabel> menuables, Style style) {
        super(id, menuables);
        this.setOutputMarkupId(true);
        WebMarkupContainer container = Wkt.add((MarkupContainer)this, Wkt.containerWithVisibility(ID_ADDITIONAL_LINK_LIST, this::hasAnyVisibleLink));
        Wkt.listViewAdd((MarkupContainer)container, ID_ADDITIONAL_LINK_ITEM, this.listOfLinkAndLabels(), (SerializableConsumer & Serializable)item -> {
            LinkAndLabel linkAndLabel = (LinkAndLabel)item.getModelObject();
            item.addOrReplace(new Component[]{WktLinks.asAdditionalLink((Component)item, ID_ADDITIONAL_LINK_TITLE, linkAndLabel, style == Style.DROPDOWN)});
            if (!linkAndLabel.isVisible()) {
                Wkt.cssAppend(item, "hidden");
            }
        });
    }

    protected final Stream<LinkAndLabel> streamLinkAndLabels() {
        return this.menuablesModel().streamMenuables(LinkAndLabel.class);
    }

    protected final List<LinkAndLabel> listOfLinkAndLabels() {
        return this.streamLinkAndLabels().collect(Collectors.toList());
    }

    public final boolean hasAnyVisibleLink() {
        return this.streamLinkAndLabels().anyMatch(linkAndLabel -> linkAndLabel.getUiComponent().isVisible());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Style {
        INLINE_LIST{

            @Override
            AdditionalLinksPanel newPanel(String id, Can<LinkAndLabel> links) {
                return new AdditionalLinksAsListInlinePanel(id, links);
            }
        }
        ,
        DROPDOWN{

            @Override
            AdditionalLinksPanel newPanel(String id, Can<LinkAndLabel> links) {
                return new AdditionalLinksAsDropDownPanel(id, links);
            }
        };


        abstract AdditionalLinksPanel newPanel(String var1, Can<LinkAndLabel> var2);
    }
}

