/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.selector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.CausewaySelectorEvent;
import org.apache.causeway.viewer.wicket.model.links.Menuable;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.model.util.PageUtils;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector._Util;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class CollectionPresentationSelectorPanel
extends PanelAbstract<DataTableInteractive, EntityCollectionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_VIEWS = "views";
    private static final String ID_VIEW_LIST = "viewList";
    private static final String ID_VIEW_LINK = "viewLink";
    private static final String ID_VIEW_ITEM = "viewItem";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    private static final String ID_VIEW_ITEM_CHECKMARK = "viewItemCheckmark";
    private static final String ID_VIEW_BUTTON_ICON = "viewButtonIcon";
    private static final String ID_SECTION_SEPARATOR = "sectionSeparator";
    private static final String ID_SECTION_LABEL = "sectionLabel";
    private final CollectionPresentationSelectorHelper selectorHelper;
    private final ComponentHintKey componentHintKey;
    private ComponentFactoryKey selectedComponentFactory;

    public CollectionPresentationSelectorPanel(String id, EntityCollectionModel model) {
        this(id, model, ComponentHintKey.noop());
    }

    public CollectionPresentationSelectorPanel(String id, EntityCollectionModel model, ComponentHintKey componentHintKey) {
        super(id, model);
        this.componentHintKey = componentHintKey;
        this.selectorHelper = new CollectionPresentationSelectorHelper(model, this.getComponentFactoryRegistry(), componentHintKey);
    }

    public void onInitialize() {
        super.onInitialize();
        this.addDropdown();
    }

    private void addDropdown() {
        Can<ComponentFactoryKey> componentFactories = this.selectorHelper.getComponentFactories();
        String selected = this.selectorHelper.honourViewHintElseDefault((Component)this);
        if (!componentFactories.isCardinalityMultiple()) {
            WktComponents.permanentlyHide((MarkupContainer)this, ID_VIEWS);
            return;
        }
        this.selectedComponentFactory = this.selectorHelper.find(selected);
        WebMarkupContainer views = new WebMarkupContainer(ID_VIEWS);
        WebMarkupContainer container = new WebMarkupContainer(ID_VIEW_LIST);
        views.addOrReplace(new Component[]{container});
        views.setOutputMarkupId(true);
        this.setOutputMarkupId(true);
        Label viewButtonIcon = Wkt.labelAdd((MarkupContainer)views, ID_VIEW_BUTTON_ICON, "");
        Wkt.listViewAdd((MarkupContainer)container, ID_VIEW_ITEM, this.sorted(componentFactories), (SerializableConsumer & Serializable)item -> {
            Menuable menuable = (Menuable)item.getModelObject();
            Menuable.Kind menuableKind = menuable.menuableKind();
            Wkt.cssAppend(item, menuableKind.getCssClassForLiElement());
            switch (menuableKind) {
                case SECTION_SEPARATOR: {
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_LABEL);
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_VIEW_LINK);
                    Wkt.labelAdd((MarkupContainer)item, ID_SECTION_SEPARATOR, "");
                    return;
                }
                case SECTION_LABEL: {
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_SEPARATOR);
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_VIEW_LINK);
                    Wkt.labelAdd((MarkupContainer)item, ID_SECTION_LABEL, ((Menuable.SectionLabel)menuable).getSectionLabel());
                    return;
                }
                case LINK: {
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_SEPARATOR);
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_LABEL);
                    break;
                }
                default: {
                    return;
                }
            }
            LinkEntry linkEntry = (LinkEntry)menuable;
            ComponentFactoryKey componentFactory = linkEntry.getComponentFactoryKey();
            if (componentFactory.componentType() == UiComponentType.COLLECTION_CONTENTS_EXPORT) {
                DownloadLink downloadLink = (DownloadLink)componentFactory.resolve(() -> ((CollectionPresentationSelectorPanel)this).getServiceRegistry()).createComponent(ID_VIEW_LINK, (IModel<?>)this.getModel());
                WktComponents.permanentlyHide((MarkupContainer)downloadLink, ID_VIEW_ITEM_CHECKMARK);
                item.addOrReplace(new Component[]{downloadLink});
                CollectionPresentationSelectorPanel.addLinkWithIconAndTitle((ListItem<? extends Menuable>)item, (MarkupContainer)downloadLink);
                return;
            }
            AjaxLinkNoPropagate link = Wkt.linkAdd((MarkupContainer)item, ID_VIEW_LINK, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                CollectionPresentationSelectorPanel linksSelectorPanel = this;
                linksSelectorPanel.setViewHintAndBroadcast(componentFactory.id(), (AjaxRequestTarget)target);
                linksSelectorPanel.selectedComponentFactory = componentFactory;
                ((EntityCollectionModel)this.getModel()).parentedHintingBookmark().ifPresent(bookmark -> this.componentHintKey.set(bookmark, componentFactory.id()));
                if (linkEntry.isPageReloadRequiredOnTableViewActivation()) {
                    PageUtils.pageReload();
                } else {
                    target.add(new Component[]{linksSelectorPanel, views});
                }
            });
            CollectionPresentationSelectorPanel.addLinkWithIconAndTitle((ListItem<? extends Menuable>)item, (MarkupContainer)link);
            Label checkmarkForSelectedPresentation = Wkt.labelAdd((MarkupContainer)link, ID_VIEW_ITEM_CHECKMARK, "");
            boolean isSelectedPresentation = linkEntry.isSelectedIn(this);
            checkmarkForSelectedPresentation.setVisible(isSelectedPresentation);
            if (isSelectedPresentation) {
                linkEntry.markAsSelected(viewButtonIcon, link);
            }
        });
        this.addOrReplace(new Component[]{views});
    }

    private List<Menuable> sorted(Can<ComponentFactoryKey> componentFactories) {
        List<LinkEntry> presentations = this.sorted(componentFactories, _Util.filterTablePresentations());
        List<LinkEntry> exports = this.sorted(componentFactories, _Util.filterTableExports());
        ArrayList<Menuable> sortedWithSeparators = new ArrayList<Menuable>(presentations.size() + exports.size() + 2);
        boolean needsSpacer = false;
        if (!presentations.isEmpty()) {
            sortedWithSeparators.add((Menuable)Menuable.sectionLabel((String)this.translate("Presentations")));
            sortedWithSeparators.addAll(presentations);
            needsSpacer = true;
        }
        if (!exports.isEmpty()) {
            if (needsSpacer) {
                sortedWithSeparators.add((Menuable)Menuable.sectionSeparator());
            }
            sortedWithSeparators.add((Menuable)Menuable.sectionLabel((String)this.translate("Exports")));
            sortedWithSeparators.addAll(exports);
        }
        return sortedWithSeparators;
    }

    private List<LinkEntry> sorted(Can<ComponentFactoryKey> componentFactories, Predicate<? super ComponentFactoryKey> filter) {
        List<LinkEntry> sorted = componentFactories.stream().filter(filter).sorted(_Util.orderByOrderOfAppearanceInUiDropdown()).map(factory -> LinkEntry.linkEntry(factory)).collect(Collectors.toList());
        return sorted;
    }

    protected void setViewHintAndBroadcast(String viewName, AjaxRequestTarget target) {
        CollectionPresentationSelectorPanel component = this;
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new CausewaySelectorEvent((Component)component, "selectedItem", viewName, target));
    }

    static void addLinkWithIconAndTitle(@NonNull ListItem<? extends Menuable> item, @NonNull MarkupContainer link) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (link == null) {
            throw new NullPointerException("link is marked non-null but is null");
        }
        WktLinks.listItemAsDropdownLink(item, link, ID_VIEW_ITEM_TITLE, LinkEntry::nameFor, ID_VIEW_ITEM_ICON, null, LinkEntry::cssClassFor);
    }

    static final class LinkEntry
    implements Menuable {
        private static final long serialVersionUID = 1L;
        private final ComponentFactoryKey componentFactoryKey;

        public static LinkEntry linkEntry(@NonNull ComponentFactoryKey componentFactoryKey) {
            if (componentFactoryKey == null) {
                throw new NullPointerException("componentFactoryKey is marked non-null but is null");
            }
            return new LinkEntry(componentFactoryKey);
        }

        boolean isSelectedIn(CollectionPresentationSelectorPanel panel) {
            return Objects.equals(this.componentFactoryKey, panel.selectedComponentFactory);
        }

        boolean isPageReloadRequiredOnTableViewActivation() {
            return this.componentFactoryKey.isPageReloadRequiredOnTableViewActivation();
        }

        void markAsSelected(Label viewButtonIcon, AjaxLinkNoPropagate link) {
            Model cssClass = Model.of((Serializable)((Object)this.componentFactoryKey.cssClass()));
            _Util.initViewIcon(this.componentFactoryKey, viewButtonIcon);
            Wkt.cssReplace(viewButtonIcon, "ViewLinkItem " + (String)cssClass.getObject());
            link.setEnabled(false);
        }

        private static IModel<String> nameFor(LinkEntry linkEntry) {
            return Model.of((Serializable)((Object)linkEntry.getComponentFactoryKey().label()));
        }

        private static IModel<String> cssClassFor(LinkEntry linkEntry, Label viewIcon) {
            Model cssClass = Model.of((Serializable)((Object)linkEntry.componentFactoryKey.cssClass()));
            _Util.initViewIcon(linkEntry.componentFactoryKey, viewIcon);
            return cssClass;
        }

        public Menuable.Kind menuableKind() {
            return Menuable.Kind.LINK;
        }

        @Generated
        public LinkEntry(ComponentFactoryKey componentFactoryKey) {
            this.componentFactoryKey = componentFactoryKey;
        }

        @Generated
        public ComponentFactoryKey getComponentFactoryKey() {
            return this.componentFactoryKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkEntry)) {
                return false;
            }
            LinkEntry other = (LinkEntry)o;
            ComponentFactoryKey this$componentFactoryKey = this.getComponentFactoryKey();
            ComponentFactoryKey other$componentFactoryKey = other.getComponentFactoryKey();
            return !(this$componentFactoryKey == null ? other$componentFactoryKey != null : !this$componentFactoryKey.equals(other$componentFactoryKey));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ComponentFactoryKey $componentFactoryKey = this.getComponentFactoryKey();
            result = result * 59 + ($componentFactoryKey == null ? 43 : $componentFactoryKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CollectionPresentationSelectorPanel.LinkEntry(componentFactoryKey=" + this.getComponentFactoryKey() + ")";
        }
    }
}

