/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.multiple;

import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.hints.CausewayEnvelopeEvent;
import org.apache.causeway.viewer.wicket.model.hints.CausewaySelectorEvent;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelAbstract;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelHidden;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorProvider;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

public class CollectionContentsMultipleViewsPanel
extends PanelAbstract<DataTableInteractive, EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NUM_UNDERLYING_VIEWS = 10;
    private static final String UIHINT_VIEW = "selectedItem";
    private final String underlyingIdPrefix = UiComponentType.COLLECTION_CONTENTS.toString();
    private final CollectionPresentationSelectorHelper selectorHelper;
    private Component selectedComponent;
    private Component[] underlyingViews;

    public CollectionContentsMultipleViewsPanel(String id, EntityCollectionModel model) {
        super(id, model);
        ComponentHintKey selectedItemSessionAttribute = model.getVariant().isParented() ? ComponentHintKey.create((MetaModelContext)super.getMetaModelContext(), (Component)this, (String)UIHINT_VIEW) : null;
        this.selectorHelper = new CollectionPresentationSelectorHelper(model, this.getComponentFactoryRegistry(), selectedItemSessionAttribute);
    }

    public void onInitialize() {
        super.onInitialize();
        this.addUnderlyingViews();
    }

    private void addUnderlyingViews() {
        EntityCollectionModel visibleCollModel = (EntityCollectionModel)this.getModel();
        EntityCollectionModelHidden hiddenCollModel = EntityCollectionModelHidden.forCollectionModel((EntityCollectionModelAbstract)((EntityCollectionModelAbstract)visibleCollModel));
        Can<ComponentFactoryKey> componentFactories = this.selectorHelper.getComponentFactories();
        CollectionPresentationSelectorPanel selectorDropdownPanelIfAny = CollectionPresentationSelectorProvider.getCollectionSelectorProvider((Component)this);
        String selectedCompFactoryName = selectorDropdownPanelIfAny != null ? this.selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanelIfAny) : ((ComponentFactoryKey)componentFactories.getFirstElseFail()).id();
        int i = 0;
        int selectedIdx = 0;
        this.underlyingViews = new Component[10];
        for (ComponentFactoryKey componentFactory : componentFactories) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            boolean isSelected = selectedCompFactoryName.equals(componentFactory.id());
            Component underlyingView = componentFactory.resolve(() -> ((CollectionContentsMultipleViewsPanel)this).getServiceRegistry()).createComponent(underlyingId, (IModel<?>)(isSelected ? visibleCollModel : hiddenCollModel));
            if (isSelected) {
                selectedIdx = i;
            }
            this.underlyingViews[i++] = underlyingView;
            this.addOrReplace(new Component[]{underlyingView});
        }
        while (i < 10) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            WktComponents.permanentlyHide((MarkupContainer)this, underlyingId);
            ++i;
        }
        this.setOutputMarkupId(true);
        for (i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            if (i != selectedIdx) {
                PanelAbstract.setVisible(component, false);
                continue;
            }
            this.selectedComponent = component;
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        CausewaySelectorEvent selectorEvent = (CausewaySelectorEvent)CausewayEnvelopeEvent.openLetter(event, CausewaySelectorEvent.class);
        if (selectorEvent == null) {
            return;
        }
        CollectionPresentationSelectorPanel selectorDropdownPanel = CollectionPresentationSelectorProvider.getCollectionSelectorProvider((Component)this);
        if (selectorDropdownPanel == null) {
            return;
        }
        String selectedView = selectorEvent.hintFor((Component)selectorDropdownPanel, UIHINT_VIEW);
        if (selectedView == null) {
            return;
        }
        int underlyingViewNum = this.selectorHelper.lookup(selectedView);
        EntityCollectionModelHidden dummyModel = EntityCollectionModelHidden.forCollectionModel((EntityCollectionModelAbstract)((EntityCollectionModelAbstract)this.getModel()));
        for (int i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            boolean isSelected = i == underlyingViewNum;
            CollectionContentsMultipleViewsPanel.setVisible(component, isSelected);
            component.setDefaultModel((IModel)(isSelected ? this.getModel() : dummyModel));
        }
        this.selectedComponent = this.underlyingViews[underlyingViewNum];
        AjaxRequestTarget target = selectorEvent.getTarget();
        if (target != null) {
            target.add(new Component[]{this, selectorDropdownPanel});
        }
    }

    @Override
    public Integer getCount() {
        if (this.selectedComponent instanceof CollectionCountProvider) {
            CollectionCountProvider collectionCountProvider = (CollectionCountProvider)this.selectedComponent;
            return collectionCountProvider.getCount();
        }
        return null;
    }
}

