/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars.markup;

import java.util.EnumSet;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldWithValueSemantics;
import org.apache.causeway.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.causeway.viewer.wicket.ui.components.scalars.markup.MarkupPanelFactories;
import org.apache.wicket.Component;

public class ScalarMarkupPanel<T>
extends ScalarPanelTextFieldWithValueSemantics<T> {
    private static final long serialVersionUID = 1L;
    private final ComponentFactoryKey markupComponentFactoryKey;

    public ScalarMarkupPanel(String id, ScalarModel scalarModel, Class<T> valueType, ComponentFactoryKey markupComponentFactoryKey) {
        super(id, scalarModel, valueType);
        this.markupComponentFactoryKey = markupComponentFactoryKey;
    }

    @Override
    protected void setupFormatModifiers(EnumSet<ScalarPanelAbstract.FormatModifier> modifiers) {
        modifiers.add(ScalarPanelAbstract.FormatModifier.MARKUP);
        modifiers.add(ScalarPanelAbstract.FormatModifier.MULTILINE);
    }

    @Override
    protected Component createComponentForOutput(String id) {
        return this.createMarkupComponent(id);
    }

    protected final MarkupComponent createMarkupComponent(String id) {
        return this.markupComponentFactory().newMarkupComponent(id, this.scalarModel());
    }

    protected final MarkupPanelFactories.ParentedAbstract<?> markupComponentFactory() {
        return (MarkupPanelFactories.ParentedAbstract)this.markupComponentFactoryKey.resolve(() -> ((ScalarMarkupPanel)this).getServiceRegistry());
    }
}

