/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.causeway.applib.graph.tree.TreePath;
import org.apache.causeway.applib.graph.tree.TreeState;
import org.apache.causeway.viewer.wicket.ui.components.tree._TreeNodeMemento;
import org.apache.wicket.model.IModel;

class _TreeExpansionModel
implements IModel<Set<_TreeNodeMemento>> {
    private static final long serialVersionUID = 648152234030889164L;
    private final TreeState treeState;
    private final Set<_TreeNodeMemento> expandedNodes;

    public static _TreeExpansionModel of(TreeState treeState) {
        return new _TreeExpansionModel(treeState);
    }

    private _TreeExpansionModel(TreeState treeState) {
        this.treeState = treeState;
        this.expandedNodes = treeState.getExpandedNodePaths().stream().map(tPath -> new _TreeNodeMemento((TreePath)tPath)).collect(Collectors.toSet());
    }

    public void onExpand(_TreeNodeMemento t) {
        this.treeState.getExpandedNodePaths().add(t.getTreePath());
    }

    public void onCollapse(_TreeNodeMemento t) {
        this.treeState.getExpandedNodePaths().remove(t.getTreePath());
    }

    public boolean contains(TreePath treePath) {
        return this.treeState.getExpandedNodePaths().contains(treePath);
    }

    public boolean isSelected(TreePath treePath) {
        return this.treeState.getSelectedNodePaths().contains(treePath);
    }

    public Set<_TreeNodeMemento> getObject() {
        return this.expandedNodes;
    }

    public String toString() {
        return this.treeState.toString();
    }
}

