/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.app.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.commons.internal.base._Text;
import org.apache.causeway.commons.internal.collections._Multimaps;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public final class ComponentFactoryRegistry {
    @Generated
    private static final Logger log = LogManager.getLogger(ComponentFactoryRegistry.class);
    private final _Multimaps.ListMultimap<UiComponentType, ComponentFactory> componentFactoriesByComponentType = _Multimaps.newListMultimap();
    private final Map<Class<? extends ComponentFactory>, ComponentFactory> componentFactoriesByType = new HashMap<Class<? extends ComponentFactory>, ComponentFactory>();

    public ComponentFactoryRegistry(ComponentFactoryList factoryList, MetaModelContext mmc) {
        factoryList.forEach(compFactory -> this.registerComponentFactory(mmc, (ComponentFactory)compFactory));
        this.ensureAllComponentTypesRegistered();
    }

    public ComponentFactory findComponentFactory(UiComponentType uiComponentType, @Nullable IModel<?> model) {
        return this.streamComponentFactories(uiComponentType, model).findFirst().orElseGet(() -> this.streamComponentFactories(UiComponentType.UNKNOWN, model).findFirst().orElse(null));
    }

    public ComponentFactory findComponentFactoryElseFail(UiComponentType uiComponentType, @Nullable IModel<?> model) {
        return this.streamComponentFactories(uiComponentType, model).findFirst().orElseThrow(() -> new RuntimeException(String.format("could not find component for componentType = '%s'; model object is of type %s; model object='%s'", uiComponentType, model.getClass().getName(), model.getObject())));
    }

    public Component addOrReplaceComponent(MarkupContainer markupContainer, UiComponentType uiComponentType, IModel<?> model) {
        Component component = this.createComponent(uiComponentType, model);
        markupContainer.addOrReplace(new Component[]{component});
        return component;
    }

    public Component addOrReplaceComponent(MarkupContainer markupContainer, String id, UiComponentType uiComponentType, IModel<?> model) {
        Component component = this.createComponent(id, uiComponentType, model);
        markupContainer.addOrReplace(new Component[]{component});
        return component;
    }

    public Component createComponent(UiComponentType uiComponentType, IModel<?> model) {
        return this.findComponentFactoryElseFail(uiComponentType, model).createComponent(model);
    }

    public Component createComponent(String id, UiComponentType uiComponentType, IModel<?> model) {
        return this.findComponentFactoryElseFail(uiComponentType, model).createComponent(id, model);
    }

    public Stream<ComponentFactory> streamComponentFactories(UiComponentType uiComponentType, @Nullable IModel<?> model) {
        _Refs.ObjectReference exclusiveIfAny = _Refs.objectRef(null);
        List allThatApply = this.componentFactoriesByComponentType.streamElements((Object)uiComponentType).filter(componentFactory -> {
            ComponentFactory.ApplicationAdvice advice = componentFactory.appliesTo(uiComponentType, model);
            if (advice.appliesExclusively()) {
                exclusiveIfAny.set(componentFactory);
            }
            return advice.applies();
        }).takeWhile(__ -> exclusiveIfAny.isNull()).collect(Collectors.toList());
        return (exclusiveIfAny.isNotNull() ? Stream.of((ComponentFactory)exclusiveIfAny.getValueElseFail()) : allThatApply.stream()).peek(componentFactory -> ComponentFactoryRegistry.logComponentResolving(model, uiComponentType, componentFactory));
    }

    public Stream<ComponentFactory> streamComponentFactories(ImmutableEnumSet<UiComponentType> uiComponentTypes, @Nullable IModel<?> model) {
        return uiComponentTypes.stream().flatMap(componentType -> this.streamComponentFactories((UiComponentType)componentType, model));
    }

    public <T extends ComponentFactory> Optional<T> lookupFactory(Class<T> factoryClass) {
        return Optional.ofNullable(this.componentFactoriesByType.get(factoryClass));
    }

    public <T extends ComponentFactory> T lookupFactoryElseFail(Class<T> factoryClass) {
        return (T)((ComponentFactory)this.lookupFactory(factoryClass).orElseThrow(() -> new NoSuchElementException("Could not locate component factory of type '" + String.valueOf(factoryClass) + "'")));
    }

    private void registerComponentFactory(MetaModelContext commonContext, ComponentFactory componentFactory) {
        this.componentFactoriesByType.put(componentFactory.getClass(), componentFactory);
        commonContext.getServiceInjector().injectServicesInto((Object)componentFactory);
        if (componentFactory instanceof ComponentFactoryAbstract) {
            ((ComponentFactoryAbstract)componentFactory).setMetaModelContext(commonContext);
        }
        this.componentFactoriesByComponentType.putElement((Object)componentFactory.getComponentType(), (Object)componentFactory);
    }

    private void ensureAllComponentTypesRegistered() {
        for (UiComponentType componentType : UiComponentType.values()) {
            if (componentType.getOptionality().isOptional() || !this.componentFactoriesByComponentType.getOrElseEmpty((Object)componentType).isEmpty()) continue;
            throw new IllegalStateException("No component factories registered for " + String.valueOf(componentType));
        }
    }

    private static void logComponentResolving(IModel<?> model, UiComponentType uiComponentType, ComponentFactory componentFactory) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("component type for model {} -> {} provided by {}", (Object)_Text.abbreviateClassOf(model), (Object)uiComponentType.name(), (Object)_Text.abbreviateClassOf((Object)componentFactory));
    }
}

