/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.viewer.commons.model.decorators.ActionDecorators;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksAsButtonInlinePanel;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksAsDropDownPanel;
import org.apache.causeway.viewer.wicket.ui.components.menuable.MenuablePanelAbstract;
import org.apache.causeway.viewer.wicket.ui.components.widgets.actionlink.ActionLink;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class ActionLinksPanel
extends MenuablePanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ADDITIONAL_LINK_LIST = "additionalLinkList";
    private static final String ID_ADDITIONAL_LINK_ITEM = "additionalLinkItem";
    private static final String ID_ADDITIONAL_LINK_TITLE = "additionalLinkTitle";

    public static ActionLinksPanel addActionLinks(MarkupContainer markupContainer, String id, Can<ActionModel> links, Style style) {
        Optional<ActionLinksPanel> panel = ActionLinksPanel.actionLinks(id, links, style);
        if (panel.isEmpty()) {
            WktComponents.permanentlyHide(markupContainer, id);
            return null;
        }
        return Wkt.add(markupContainer, panel.get());
    }

    public static Optional<ActionLinksPanel> actionLinks(String id, Can<ActionModel> links, Style style) {
        if (links.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(style.newPanel(id, (Can<ActionLink>)links.map(ActionLink::create)));
    }

    protected ActionLinksPanel(String id, Can<ActionLink> actionLinks, Style style) {
        super(id, actionLinks);
        this.setOutputMarkupId(true);
        WebMarkupContainer container = Wkt.add((MarkupContainer)this, Wkt.containerWithVisibility(ID_ADDITIONAL_LINK_LIST, this::hasAnyVisibleLink));
        Wkt.listViewAdd((MarkupContainer)container, ID_ADDITIONAL_LINK_ITEM, this.listOfActionLinks(), (SerializableConsumer & Serializable)item -> {
            ActionLink linkAndLabel = (ActionLink)((Object)((Object)item.getModelObject()));
            item.addOrReplace(new Component[]{WktLinks.asActionLink((Component)item, ID_ADDITIONAL_LINK_TITLE, linkAndLabel, style.actionStyle)});
            if (!linkAndLabel.isVisible()) {
                Wkt.cssAppend(item, "hidden");
            }
        });
    }

    protected final Stream<ActionLink> streamActionLinks() {
        return this.menuablesModel().streamMenuables(ActionLink.class);
    }

    protected final List<ActionLink> listOfActionLinks() {
        return this.streamActionLinks().collect(Collectors.toList());
    }

    public final boolean hasAnyVisibleLink() {
        return this.streamActionLinks().anyMatch(ActionLink::isVisible);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Style {
        INLINE_LIST(ActionDecorators.ActionStyle.BUTTON){

            @Override
            public ActionLinksPanel newPanel(String id, Can<ActionLink> links) {
                return new ActionLinksAsButtonInlinePanel(id, links);
            }
        }
        ,
        DROPDOWN(ActionDecorators.ActionStyle.MENU_ITEM){

            @Override
            public ActionLinksPanel newPanel(String id, Can<ActionLink> links) {
                return new ActionLinksAsDropDownPanel(id, links);
            }
        };

        final ActionDecorators.ActionStyle actionStyle;

        abstract ActionLinksPanel newPanel(String var1, Can<ActionLink> var2);

        @Generated
        private Style(ActionDecorators.ActionStyle actionStyle) {
            this.actionStyle = actionStyle;
        }
    }
}

