/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes;

import java.util.Optional;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class AttributePanelWithTextField<T>
extends AttributePanelWithFormField<T> {
    private static final long serialVersionUID = 1L;
    private AbstractTextComponent<T> formField;

    protected AttributePanelWithTextField(String id, UiAttributeWkt attributeModel, Class<T> type) {
        super(id, attributeModel, type);
        this.guardAgainstIncompatibleScalarType();
    }

    protected abstract Optional<IConverter<T>> converter();

    protected final IConverter<T> converterElseFail() {
        return this.converter().orElseThrow(() -> _Exceptions.illegalState((String)"framework bug: %s requires a converter", (Object[])new Object[]{this.getClass().getSimpleName()}));
    }

    protected AbstractTextComponent<T> createTextField(String id) {
        return this.getFormatModifiers().contains((Enum)AttributePanel.FormatModifier.MULTILINE) ? Wkt.textAreaWithConverter(id, this.unwrappedModel(), this.type, this.converter()) : Wkt.textFieldWithConverter(id, this.unwrappedModel(), this.type, this.converter());
    }

    protected final IModel<T> unwrappedModel() {
        return this.attributeModel().unwrapped(this.type);
    }

    @Override
    protected final FormComponent<T> createFormComponent(String id, UiAttributeWkt attributeModel) {
        this.formField = this.createTextField(id);
        this.formField.setOutputMarkupId(true);
        return this.applyFormComponentAttributes((FormComponent)this.formField);
    }

    @Override
    protected Optional<AttributeFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(this.getFormatModifiers().contains((Enum)AttributePanel.FormatModifier.MULTILINE) ? AttributeFragmentFactory.InputFragment.TEXTAREA : AttributeFragmentFactory.InputFragment.TEXT);
    }

    @Override
    protected String obtainInlinePromptLinkCssIfAny() {
        return !this.getFormatModifiers().contains((Enum)AttributePanel.FormatModifier.MULTILINE) ? super.obtainInlinePromptLinkCssIfAny() : null;
    }

    @Override
    protected final UiString obtainOutputFormat() {
        return super.obtainOutputFormat();
    }

    private void guardAgainstIncompatibleScalarType() {
        _Assert.assertTrue((boolean)this.attributeModel().getElementType().isAssignableFrom(this.type), () -> String.format("[%s:%s] cannot possibly unwrap model of type %s into target type %s", this.getClass().getSimpleName(), this.attributeModel().getIdentifier(), this.attributeModel().getElementType().getCorrespondingClass(), this.type));
    }

    <F extends FormComponent<?>> F applyFormComponentAttributes(F formComponent) {
        UiAttributeWkt attributeModel = this.attributeModel();
        Wkt.setFormComponentAttributes(formComponent, () -> ((UiAttributeWkt)attributeModel).multilineNumberOfLines(), () -> ((UiAttributeWkt)attributeModel).maxLength(), () -> ((UiAttributeWkt)attributeModel).typicalLength());
        return formComponent;
    }
}

