/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.bool;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxX;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import java.util.Optional;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.BooleanModel;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

class BooleanAttributePanel
extends AttributePanelWithFormField<Boolean> {
    private static final long serialVersionUID = 1L;
    private CheckBoxX checkBox;

    public BooleanAttributePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel, Boolean.class);
    }

    @Override
    protected Optional<AttributeFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(AttributeFragmentFactory.InputFragment.CHECKBOX);
    }

    @Override
    protected FormComponent<Boolean> createFormComponent(String id, UiAttributeWkt attributeModel) {
        this.checkBox = Wkt.checkboxX(id, (IModel<Boolean>)BooleanModel.forAttributeModel((UiAttributeWkt)attributeModel), attributeModel.isRequired(), CheckBoxXConfig.Sizes.xl);
        return this.checkBox;
    }

    @Override
    protected Component createComponentForOutput(String id) {
        Boolean b = (Boolean)this.attributeModel().getObject().getPojo();
        if (b == null && this.attributeModel().isRequired()) {
            b = false;
        }
        return this.getRenderScenario().isCompact() ? AttributeFragmentFactory.CompactFragment.createCheckboxFragment(id, (MarkupContainer)this, b) : AttributeFragmentFactory.PromptFragment.createCheckboxFragment(id, (MarkupContainer)this, b);
    }

    @Override
    protected UiString obtainOutputFormat() {
        throw _Exceptions.unexpectedCodeReach();
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(true);
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(false);
        Wkt.attributeReplace(this.checkBox, "title", disableReason);
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        super.onMakeNotEditable(disableReason);
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(false);
        Wkt.attributeReplace(this.checkBox, "title", disableReason);
    }

    @Override
    protected void onMakeEditable() {
        super.onMakeEditable();
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setEnabled(true);
    }

    @Override
    public String getVariation() {
        return super.getVariation();
    }
}

