/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.choices;

import java.util.Optional;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.AttributePanelWithSelect;
import org.apache.causeway.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderDefault;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.wicketstuff.select2.AbstractSelect2Choice;

class ValueChoicesAttributePanel
extends AttributePanelWithSelect
implements AttributePanelWithSelect.ChoiceTitleHandler {
    private static final long serialVersionUID = 1L;
    private final boolean isCompactFormat;

    public ValueChoicesAttributePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
        this.isCompactFormat = attributeModel.getRenderingHint().isInTable();
    }

    @Override
    protected Component createComponentForOutput(String id) {
        return Wkt.label(id, "placeholder");
    }

    @Override
    protected FormComponent<ManagedObject> createFormComponent(String id, UiAttributeWkt attributeModel) {
        if (this.select2 == null) {
            this.select2 = this.createSelect2(id, ChoiceProviderDefault::new);
        } else {
            this.select2.clearInput();
        }
        AbstractSelect2Choice<ObjectMemento, ?> formComponent = this.select2.asComponent();
        return formComponent;
    }

    @Override
    protected final Optional<AttributeFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(AttributeFragmentFactory.InputFragment.SELECT_VALUE);
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        if (this.isCompactFormat) {
            return;
        }
        this.select2.setEnabled(false);
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        if (this.isCompactFormat) {
            return;
        }
        this.select2.setEnabled(true);
        this.clearTitleAttribute();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        if (this.isCompactFormat) {
            return;
        }
        this.setTitleAttribute(disableReason);
        this.select2.setEnabled(false);
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        super.onMakeNotEditable(disableReason);
        if (this.isCompactFormat) {
            return;
        }
        this.setTitleAttribute(disableReason);
        this.select2.setEnabled(false);
    }

    @Override
    protected void onMakeEditable() {
        super.onMakeEditable();
        if (this.isCompactFormat) {
            return;
        }
        this.clearTitleAttribute();
        this.select2.setEnabled(true);
    }

    @Override
    public void clearTitleAttribute() {
        MarkupContainer target = this.getRegularFrame();
        WktTooltips.clearTooltip((Component)target);
    }

    @Override
    public void setTitleAttribute(String titleAttribute) {
        if (_Strings.isNullOrEmpty((CharSequence)titleAttribute)) {
            this.clearTitleAttribute();
            return;
        }
        MarkupContainer target = this.getRegularFrame();
        WktTooltips.addTooltip(target, titleAttribute);
    }
}

