/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.image;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.decorators.FormLabelDecorator;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.image._WktImageUtil;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;

class JavaAwtImagePanel
extends PanelAbstract<ManagedObject, UiAttributeWkt> {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_VALUE = "scalarValue";
    private static final String ID_FEEDBACK = "feedback";

    public JavaAwtImagePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
        this.buildGui();
    }

    private void buildGui() {
        Wkt.add((MarkupContainer)this, this.createScalarNameLabel(ID_SCALAR_NAME));
        Image wicketImage = _WktImageUtil.asWicketImage(ID_SCALAR_VALUE, this.attributeModel()).orElse(null);
        if (wicketImage != null) {
            this.addOrReplace(new Component[]{wicketImage});
            this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, (Component)wicketImage, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter((Component)wicketImage))});
        } else {
            WktComponents.permanentlyHide((MarkupContainer)this, ID_SCALAR_VALUE, ID_FEEDBACK);
        }
    }

    public String getVariation() {
        return Facets.labelAt((ObjectFeature)this.attributeModel().getMetaModel()).name();
    }

    protected Label createScalarNameLabel(String id) {
        UiAttributeWkt attributeModel = this.attributeModel();
        Label scalarNameLabel = Wkt.label(id, attributeModel.getFriendlyName());
        WktDecorators.formLabel().decorate((Component)scalarNameLabel, FormLabelDecorator.FormLabelDecorationModel.mandatory((boolean)attributeModel.isShowMandatoryIndicator()));
        attributeModel.getDescribedAs().ifPresent(describedAs -> WktTooltips.addTooltip(scalarNameLabel, describedAs));
        return scalarNameLabel;
    }

    protected final UiAttributeWkt attributeModel() {
        return (UiAttributeWkt)this.getModel();
    }
}

