/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.export;

import java.io.File;
import java.io.Serializable;
import org.apache.causeway.applib.tabular.TabularExporter;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.core.metamodel.tabular.simple.DataTable;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.components.download.FileDownloadLink;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.file.Files;

@org.springframework.stereotype.Component
public class CollectionContentsAsExportFactory
extends ComponentFactoryAbstract
implements CollectionContentsAsFactory {
    private final TabularExporter tabularExporter;

    public CollectionContentsAsExportFactory(TabularExporter collectionContentsExporter) {
        super(UiComponentType.COLLECTION_CONTENTS_EXPORT, collectionContentsExporter.getClass().getName(), DownloadLink.class);
        this.tabularExporter = collectionContentsExporter;
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof CollectionModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        CollectionModel collectionModel = (CollectionModel)model;
        return this.tabularExporter.appliesTo(collectionModel.getElementType().getCorrespondingClass()) ? ComponentFactory.ApplicationAdvice.APPLIES : ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        CollectionModel collectionModel = (CollectionModel)model;
        NamedWithMimeType.CommonMimeType mimeType = this.tabularExporter.getMimeType();
        String ext = (String)mimeType.getProposedFileExtensions().getFirstElseFail();
        String fileName = collectionModel.getName().replaceAll(" ", "") + "." + ext;
        FileDownloadLink link = new FileDownloadLink(id, mimeType, fileName, new FileModel(this, collectionModel, fileName));
        return link;
    }

    @Override
    public IModel<String> getTitleLabel() {
        return Model.of((Serializable)((Object)this.tabularExporter.getTitleLabel()));
    }

    @Override
    public IModel<String> getCssClass() {
        return Model.of((Serializable)((Object)this.tabularExporter.getCssClass()));
    }

    @Override
    public int orderOfAppearanceInUiDropdown() {
        return this.tabularExporter.orderOfAppearanceInUiDropdown();
    }

    static class FileModel
    implements IModel<File> {
        private static final long serialVersionUID = 1L;
        private ComponentFactoryKey key;
        private CollectionModel model;
        private String fileName;

        FileModel(CollectionContentsAsExportFactory x, CollectionModel model, String fileName) {
            this.key = x.key();
            this.model = model;
            this.fileName = fileName;
        }

        public File getObject() {
            File tempFile = File.createTempFile(CollectionContentsAsExportFactory.class.getCanonicalName(), this.fileName);
            Try.run(() -> this.exporter().export(this.model.getDataTableModel().export().toTabularSheet(DataTable.AccessMode.USER), tempFile)).ifFailure(__ -> Files.remove((File)tempFile)).ifFailureFail();
            return tempFile;
        }

        private TabularExporter exporter() {
            return ((CollectionContentsAsExportFactory)this.key.componentFactory()).tabularExporter;
        }
    }
}

