/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.parented;

import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.annotation.TableDecorator;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelParented;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.CollectionPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.causeway.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;

class ParentedCollectionPanel
extends PanelAbstract<ManagedObject, UiObjectWkt>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_COLLECTION_GROUP = "collectionGroup";
    private static final String ID_COLLECTION_NAME = "collectionName";
    private static final String ID_COLLECTION = "collection";
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final ComponentHintKey selectedItemHintKey;
    private boolean visible = false;
    private CollectionPresentationSelectorPanel selectorDropdownPanel;
    private final CollectionLayoutData layoutData;
    private final WebMarkupContainer div;
    private transient CollectionModelParented collectionModelParented;
    private transient Optional<TableDecorator> tableDecorator;

    public ParentedCollectionPanel(String id, UiObjectWkt objectModel, CollectionLayoutData layoutData) {
        super(id, objectModel);
        this.layoutData = layoutData;
        this.div = new WebMarkupContainer(ID_COLLECTION_GROUP);
        this.selectedItemHintKey = ComponentHintKey.create((MetaModelContext)super.getMetaModelContext(), this::getSelectorDropdownPanel, (String)"selectedItem");
        this.buildGui();
    }

    public void onInitialize() {
        super.onInitialize();
        ParentedCollectionPanel panel = this;
        if (this.visible) {
            panel.add(new Component[]{this.div});
            this.setOutputMarkupId(true);
        } else {
            WktComponents.permanentlyHide((MarkupContainer)panel, this.div.getId());
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.tableDecorator().ifPresent(tableDecorator -> this.renderHeadForTableDecorator(response, (TableDecorator)tableDecorator));
    }

    private void buildGui() {
        CollectionModelParented collectionModel = this.collectionModelParented();
        this.div.setMarkupId("collection-" + collectionModel.getLayoutData().getId());
        OneToManyAssociation collectionMetaModel = collectionModel.getMetaModel();
        Wkt.cssAppend(this.div, collectionModel.getIdentifier());
        Wkt.cssAppend(this.div, collectionModel.getElementType().getFeatureIdentifier());
        ManagedObject objectAdapter = (ManagedObject)((UiObjectWkt)this.getModel()).getObject();
        Consent visibility = collectionMetaModel.isVisible(objectAdapter, InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        if (visibility.isAllowed()) {
            this.visible = true;
            Facets.cssClass((FacetHolder)collectionMetaModel, (ManagedObject)objectAdapter).ifPresent(cssClass -> Wkt.cssAppend(this.div, cssClass));
            this.tableDecorator().ifPresent(tableDecorator -> Wkt.cssAppend(this.div, tableDecorator.cssClass()));
            CollectionPanel collectionPanel = new CollectionPanel(ID_COLLECTION, collectionModel);
            this.div.addOrReplace(new Component[]{collectionPanel});
            Label labelComponent = Wkt.label(ID_COLLECTION_NAME, collectionMetaModel.getFriendlyName(() -> collectionModel.getParentObject()));
            labelComponent.setEscapeModelStrings(true);
            this.div.add(new Component[]{labelComponent});
            collectionMetaModel.getDescription(() -> collectionModel.getParentObject()).ifPresent(description -> WktTooltips.addTooltip(labelComponent, description));
            Can links = collectionModel.getLinks();
            ActionLinksPanel.addActionLinks((MarkupContainer)this.div, ID_ADDITIONAL_LINKS, (Can<ActionModel>)links, ActionLinksPanel.Style.INLINE_LIST);
            this.createSelectorDropdownPanel((CollectionModel)collectionModel);
            collectionPanel.setSelectorDropdownPanel(this.selectorDropdownPanel);
        }
    }

    private CollectionModelParented collectionModelParented() {
        if (this.collectionModelParented == null) {
            this.collectionModelParented = CollectionModelParented.forParentObjectModel((UiObjectWkt)((UiObjectWkt)this.getModel()), (CollectionLayoutData)this.layoutData);
        }
        return this.collectionModelParented;
    }

    private Optional<TableDecorator> tableDecorator() {
        if (this.tableDecorator == null) {
            this.tableDecorator = this.collectionModelParented().getMetaModel().getTableDecorator();
        }
        return this.tableDecorator;
    }

    private void createSelectorDropdownPanel(CollectionModel collectionModel) {
        CollectionPresentationSelectorHelper selectorHelper = new CollectionPresentationSelectorHelper(collectionModel, this.getComponentFactoryRegistry(), this.selectedItemHintKey);
        if (selectorHelper.factoryKeys().isCardinalityMultiple()) {
            this.selectorDropdownPanel = new CollectionPresentationSelectorPanel(ID_SELECTOR_DROPDOWN, collectionModel, this.selectedItemHintKey);
            this.div.addOrReplace(new Component[]{this.selectorDropdownPanel});
        } else {
            WktComponents.permanentlyHide((MarkupContainer)this.div, ID_SELECTOR_DROPDOWN);
        }
    }

    @Override
    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    protected CollectionPresentationSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }
}

