/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.panels;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.debug._Probe;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.wicket.model.hints.CausewayActionCompletedEvent;
import org.apache.causeway.viewer.wicket.model.hints.CausewayEventLetterAbstract;
import org.apache.causeway.viewer.wicket.model.hints.CausewayPropertyEditCompletedEvent;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.causeway.viewer.wicket.model.models.FormExecutor;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.PropertyModel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeModelChangeListener;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.pages.obj.DomainObjectPage;
import org.apache.causeway.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.causeway.viewer.wicket.ui.panels.OkCancelForm;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class PromptFormAbstract<T extends FormExecutorContext & IModel<ManagedObject>>
extends OkCancelForm<T>
implements AttributeModelChangeListener {
    private static final long serialVersionUID = 1L;
    protected final List<AttributePanel> paramPanels = _Lists.newArrayList();
    private final Component parentPanel;

    protected PromptFormAbstract(String id, Component parentPanel, T model) {
        super(id, (IModel<ManagedObject>)((IModel)model));
        this.parentPanel = parentPanel;
        this.addParameters();
    }

    private FormExecutorContext formExecutorContext() {
        return (FormExecutorContext)this.getModel();
    }

    protected abstract void addParameters();

    protected abstract Either<ActionModel, PropertyModel> getMemberModel();

    public final void renderHead(IHeaderResponse response) {
        super.renderHead(response);
    }

    @Override
    protected final void configureCancelButton(AjaxButton cancelButton) {
        super.configureCancelButton(cancelButton);
        if (this.formExecutorContext().getPromptStyle().isInlineAny()) {
            Wkt.behaviorAddFireOnEscapeKey((Component)cancelButton, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onCancelSubmitted));
        }
    }

    @Override
    protected final void onOkSubmitted(AjaxButton okButton, AjaxRequestTarget target) {
        _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking OK on an inline editing form or action prompt.");
        this.setLastFocusHint();
        Form form = okButton.getForm();
        FormExecutor formExecutor = FormExecutorDefault.forMember(this.getMemberModel());
        FormExecutor.FormExecutionOutcome outcome = formExecutor.executeAndProcessResults(target, form, this.formExecutorContext());
        if (outcome.isSuccess()) {
            this.completePrompt(target);
            okButton.send((IEventSink)target.getPage(), Broadcast.EXACT, (Object)((CausewayEventLetterAbstract)this.getMemberModel().fold(act -> new CausewayActionCompletedEvent(target), prop -> new CausewayPropertyEditCompletedEvent(target))));
            WktComponents.addToAjaxRequest(target, (Component)form);
        }
    }

    @Override
    public final void onCancelSubmitted(AjaxRequestTarget target) {
        _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking CANCEL (or hitting ESC) on an inline editing form or action prompt.");
        this.setLastFocusHint();
        this.completePrompt(target);
    }

    @Override
    public final void onError(AjaxRequestTarget target, AttributePanel scalarPanel) {
        if (scalarPanel != null) {
            target.add(new Component[]{scalarPanel});
        }
    }

    private void completePrompt(AjaxRequestTarget target) {
        if (this.formExecutorContext().isWithinInlinePrompt()) {
            this.rebuildGuiAfterInlinePromptDone(target);
        } else {
            this.closePromptIfAny(target);
        }
    }

    private void closePromptIfAny(AjaxRequestTarget target) {
        try {
            ActionPromptProvider.getFrom((Component)this.parentPanel).closePrompt(target);
        }
        catch (WicketRuntimeException wicketRuntimeException) {
            // empty catch block
        }
    }

    private void setLastFocusHint() {
        UiHintContainer objectModel = this.pageUiHintContainerIfAny();
        if (objectModel == null) {
            return;
        }
        MarkupContainer parentContainer = this.parentPanel.getParent();
        if (parentContainer == null) {
            return;
        }
        objectModel.setHint((Component)this.getPage(), "focus", parentContainer.getPageRelativePath());
    }

    private UiHintContainer pageUiHintContainerIfAny() {
        Page page;
        try {
            page = this.getPage();
        }
        catch (WicketRuntimeException ex) {
            return null;
        }
        if (page instanceof DomainObjectPage) {
            DomainObjectPage domainObjectPage = (DomainObjectPage)page;
            return domainObjectPage.getUiHintContainerIfAny();
        }
        return null;
    }

    private void rebuildGuiAfterInlinePromptDone(AjaxRequestTarget target) {
        target.add(new Component[]{this.parentPanel.getParent()});
        Wkt.containerAdd(this.parentPanel.getParent(), this.parentPanel.getId()).setVisible(false);
        this.formExecutorContext().getInlinePromptContext().onCancel(this.getMemberModel());
        Optional.ofNullable(this.formExecutorContext().getInlinePromptContext().getScalarTypeContainer()).ifPresent(scalarTypeContainer -> Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PROPERTY, scalarTypeContainer.getMarkupId()));
    }
}

