/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.apache.causeway.applib.services.linking.DeepLinkService;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.tabular.DataColumn;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.AssociationColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ColumnAbbreviationOptions;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

public final class PluralColumn
extends AssociationColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final RenderOptions opts;

    public PluralColumn(ObjectSpecification elementType, CollectionModel.Variant collectionVariant, IModel<String> columnNameModel, String propertyId, String parentTypeName, Optional<String> describedAs, RenderOptions opts) {
        super(elementType, collectionVariant, columnNameModel, Optional.empty(), propertyId, parentTypeName, describedAs);
        this.opts = opts;
    }

    @Override
    protected Component createCellComponent(String componentId, DataRowWkt dataRowWkt) {
        DataColumn dataColumn;
        DataRow dataRow = dataRowWkt.getObject();
        Can cellElements = dataRow.getCellElementsForColumn(dataColumn = (DataColumn)dataRow.lookupColumnById(this.memberId).orElseThrow());
        if (cellElements.isEmpty()) {
            return Wkt.markup(componentId, this.opts.isRenderEmptyBadge() ? this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION) : "");
        }
        RepeatingView container = new RepeatingView(componentId);
        cellElements.stream().limit(this.opts.maxElements()).forEach(cellElement -> container.add(new Component[]{this.createCellElementComponent(container.newChildId(), dataColumn, (ManagedObject)cellElement)}));
        int overflow = cellElements.size() - this.opts.maxElements();
        if (overflow > 0) {
            String href = this.getMetaModelContext().getServiceRegistry().lookupService(DeepLinkService.class).map(deepLinkService -> deepLinkService.deepLinkFor((Object)dataRow.rowElement())).map(URI::toString).orElse("#");
            Wkt.markupAdd((MarkupContainer)container, container.newChildId(), this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.HAS_MORE, Map.of("number", "" + overflow, "href", href)));
        }
        return container;
    }

    private Component createCellElementComponent(String componentId, DataColumn dataColumn, ManagedObject cellElement) {
        if (ManagedObjects.isValue((ManagedObject)cellElement)) {
            ValueModel valueModel = new ValueModel((ObjectMember)dataColumn.associationMetaModel(), cellElement);
            ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.VALUE, (IModel<?>)valueModel);
            return componentFactory.createComponent(componentId, (IModel<?>)valueModel);
        }
        UiObjectWkt uiObject = UiObjectWkt.ofAdapterForCollection((ManagedObject)cellElement, (CollectionModel.Variant)this.collectionVariant);
        ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.OBJECT_LINK, (IModel<?>)uiObject);
        Component objectLink = componentFactory.createComponent(componentId, (IModel<?>)uiObject);
        new ColumnAbbreviationOptions(this.opts.titleAbbreviationThreshold()).applyTo(objectLink);
        return objectLink;
    }

    public record RenderOptions(int titleAbbreviationThreshold, int maxElements, boolean isRenderEmptyBadge) implements Serializable
    {
    }
}

