/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.object.icontitle;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.apache.causeway.applib.layout.component.CssClassFaPosition;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.base._Text;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.MmTitleUtils;
import org.apache.causeway.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ColumnAbbreviationOptions;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.danekja.java.util.function.serializable.SerializableBooleanSupplier;

class ObjectIconAndTitlePanel
extends PanelAbstract<ManagedObject, ObjectAdapterModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_OBJECT_LINK_WRAPPER = "objectLinkWrapper";
    private static final String ID_OBJECT_FONT_AWESOME_LEFT = "objectIconFaLeft";
    private static final String ID_OBJECT_FONT_AWESOME_RIGHT = "objectIconFaRight";
    private static final String ID_OBJECT_LINK = "objectLink";
    private static final String ID_OBJECT_TITLE = "objectTitle";
    private static final String ID_OBJECT_ICON = "objectImage";
    private TitleRecord cachedTitle;

    public ObjectIconAndTitlePanel(String id, ObjectAdapterModel objectAdapterModel) {
        super(id, objectAdapterModel);
        ObjectIconAndTitlePanel.guardAgainstNonEmptyAbstractSingular(objectAdapterModel);
    }

    protected ManagedObject linkedDomainObject() {
        ManagedObject linkedDomainObject = (ManagedObject)((ObjectAdapterModel)this.getModel()).getObject();
        return linkedDomainObject;
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    protected void onLinkWrapperCreated(MarkupContainer linkWrapper) {
    }

    private void buildGui() {
        this.addLinkWrapper();
        this.setOutputMarkupId(true);
    }

    private void addLinkWrapper() {
        WebMarkupContainer linkWrapper = Wkt.container(ID_OBJECT_LINK_WRAPPER);
        linkWrapper.addOrReplace(new Component[]{this.createLinkWithIconAndTitle()});
        this.addOrReplace(new Component[]{linkWrapper});
        this.onLinkWrapperCreated((MarkupContainer)linkWrapper);
    }

    private AbstractLink createLinkWithIconAndTitle() {
        ManagedObject linkedDomainObject = this.linkedDomainObject();
        AbstractLink link = this.createDynamicallyVisibleLink(linkedDomainObject);
        if (this.isTitleSuppressed()) {
            this.hideTitle();
        }
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)linkedDomainObject)) {
            WktComponents.permanentlyHide((MarkupContainer)link, ID_OBJECT_ICON);
            Wkt.labelAdd((MarkupContainer)link, ID_OBJECT_TITLE, this.titleAbbreviated("(no object)"));
        } else {
            linkedDomainObject.eitherIconOrFaLayers().accept(objectIcon -> {
                Wkt.imageAddCachable((MarkupContainer)link, ID_OBJECT_ICON, this.getImageResourceCache().resourceReferenceForObjectIcon(objectIcon));
                WktComponents.permanentlyHide((MarkupContainer)link, ID_OBJECT_FONT_AWESOME_LEFT);
                WktComponents.permanentlyHide((MarkupContainer)link, ID_OBJECT_FONT_AWESOME_RIGHT);
            }, faLayers -> {
                WktComponents.permanentlyHide((MarkupContainer)link, ID_OBJECT_ICON);
                if (CssClassFaPosition.isLeftOrUnspecified((CssClassFaPosition)faLayers.position())) {
                    Wkt.faIconLayersAdd((MarkupContainer)link, ID_OBJECT_FONT_AWESOME_LEFT, faLayers);
                    WktComponents.permanentlyHide((MarkupContainer)link, ID_OBJECT_FONT_AWESOME_RIGHT);
                } else {
                    WktComponents.permanentlyHide((MarkupContainer)link, ID_OBJECT_FONT_AWESOME_LEFT);
                    Wkt.faIconLayersAdd((MarkupContainer)link, ID_OBJECT_FONT_AWESOME_RIGHT, faLayers);
                }
            });
            TitleRecord title = this.determineTitle(linkedDomainObject);
            Wkt.labelAdd((MarkupContainer)link, ID_OBJECT_TITLE, title.abbreviatedTitle());
            if (this.isTitleSuppressed() || title.isTitleAbbreviated()) {
                String body = title.isFullTitleEqualToBody() ? title.tooltipBody() : title.tooltipBodyIncludingFullTitle();
                WktTooltips.addTooltip(link, title.tooltipTitle(), body);
            } else if (title.isTooltipTitleEqualToBody()) {
                WktTooltips.addTooltip(link, title.tooltipBody());
            } else {
                String body = title.isFullTitleEqualToBody() ? title.tooltipBody() : title.tooltipBodyIncludingFullTitle();
                WktTooltips.addTooltip(link, title.tooltipTitle(), body);
            }
        }
        return link;
    }

    private boolean isTitleSuppressed() {
        return ((ObjectAdapterModel)this.getModel()).isInlinePrompt() && ((ObjectAdapterModel)this.getModel()).getRenderingHint().isNotInTable();
    }

    private AbstractLink createDynamicallyVisibleLink(ManagedObject linkedDomainObject) {
        PageParameters pageParameters = PageParameterUtils.createPageParametersForBookmarkablePageLink((ManagedObject)linkedDomainObject);
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.DOMAIN_OBJECT);
        return Wkt.bookmarkablePageLinkWithVisibility(ID_OBJECT_LINK, pageClass, pageParameters, (SerializableBooleanSupplier & Serializable)() -> this.isLinkVisible(this.linkedDomainObject()));
    }

    private boolean isLinkVisible(ManagedObject linkedDomainObject) {
        return linkedDomainObject != null && (linkedDomainObject.getPojo() != null || linkedDomainObject.isBookmarkMemoized());
    }

    private String titleAbbreviated(String titleString) {
        int maxTitleLength = this.abbreviateTo((ObjectAdapterModel)this.getModel(), titleString);
        return _Text.abbreviated((String)titleString, (int)maxTitleLength);
    }

    private TitleRecord determineTitle(ManagedObject linkedDomainObject) {
        if (this.cachedTitle != null) {
            return this.cachedTitle;
        }
        String fullTitle = MmTitleUtils.getTitleHonoringTitlePartSkipping((ManagedObject)linkedDomainObject, this::isContextAdapter);
        this.cachedTitle = TitleRecord.builder().fullTitle(fullTitle).abbreviatedTitle(this.titleAbbreviated(fullTitle)).tooltipTitle(_Strings.nullToEmpty((String)linkedDomainObject.objSpec().getSingularName())).tooltipBody(_Strings.nonEmpty((CharSequence)linkedDomainObject.objSpec().getDescription()).orElseGet(() -> fullTitle)).build();
        return this.cachedTitle;
    }

    private void hideTitle() {
        Wkt.cssAppend(this, "inlinePrompt");
    }

    private int abbreviateTo(ObjectAdapterModel model, String titleString) {
        int maxTitleLengthOverride = ColumnAbbreviationOptions.lookupIn((Component)this).map(ColumnAbbreviationOptions::maxElementTitleLength).orElse(-1);
        if (maxTitleLengthOverride > -1) {
            return maxTitleLengthOverride;
        }
        if (model.getRenderingHint().isInStandaloneTableTitleColumn()) {
            return this.getWicketViewerSettings().getMaxTitleLengthInStandaloneTables();
        }
        if (model.getRenderingHint().isInParentedTableTitleColumn()) {
            return this.getWicketViewerSettings().getMaxTitleLengthInParentedTables();
        }
        return titleString.length();
    }

    private boolean isContextAdapter(ManagedObject other) {
        return ((ObjectAdapterModel)this.getModel()).isContextAdapter(other);
    }

    private static void guardAgainstNonEmptyAbstractSingular(ObjectAdapterModel objectAdapterModel) {
        ManagedObject obj = (ManagedObject)objectAdapterModel.getObject();
        _Assert.assertFalse((boolean)ObjectIconAndTitlePanel.isNonEmptyAbstractSingular(obj), () -> String.format("model for EntityIconAndTitlePanel, when non-empty, must not represent abstract types; however, got an abstract %s for object of type %s", obj.objSpec(), obj.getPojo().getClass().getName()));
    }

    private static boolean isNonEmptyAbstractSingular(ManagedObject obj) {
        if (obj == null || obj.getPojo() == null || ManagedObjects.isPacked((ManagedObject)obj)) {
            return false;
        }
        return obj.objSpec().isAbstract();
    }

    private record TitleRecord(String fullTitle, String abbreviatedTitle, String tooltipTitle, String tooltipBody) implements Serializable
    {
        final boolean isTooltipTitleEqualToBody() {
            return _Strings.nullToEmpty((String)this.tooltipTitle).equalsIgnoreCase(_Strings.nullToEmpty((String)this.tooltipBody));
        }

        public boolean isFullTitleEqualToBody() {
            return _Strings.nullToEmpty((String)this.fullTitle).equalsIgnoreCase(_Strings.nullToEmpty((String)this.tooltipBody));
        }

        final boolean isTitleAbbreviated() {
            return !Objects.equals(this.abbreviatedTitle, this.fullTitle);
        }

        final String tooltipBodyIncludingFullTitle() {
            return _Strings.nullToEmpty((String)this.fullTitle) + "\n-\n" + _Strings.nullToEmpty((String)this.tooltipBody);
        }

        @Generated
        public static TitleRecordBuilder builder() {
            return new TitleRecordBuilder();
        }

        @Generated
        public static class TitleRecordBuilder {
            @Generated
            private String fullTitle;
            @Generated
            private String abbreviatedTitle;
            @Generated
            private String tooltipTitle;
            @Generated
            private String tooltipBody;

            @Generated
            TitleRecordBuilder() {
            }

            @Generated
            public TitleRecordBuilder fullTitle(String fullTitle) {
                this.fullTitle = fullTitle;
                return this;
            }

            @Generated
            public TitleRecordBuilder abbreviatedTitle(String abbreviatedTitle) {
                this.abbreviatedTitle = abbreviatedTitle;
                return this;
            }

            @Generated
            public TitleRecordBuilder tooltipTitle(String tooltipTitle) {
                this.tooltipTitle = tooltipTitle;
                return this;
            }

            @Generated
            public TitleRecordBuilder tooltipBody(String tooltipBody) {
                this.tooltipBody = tooltipBody;
                return this;
            }

            @Generated
            public TitleRecord build() {
                return new TitleRecord(this.fullTitle, this.abbreviatedTitle, this.tooltipTitle, this.tooltipBody);
            }

            @Generated
            public String toString() {
                return "ObjectIconAndTitlePanel.TitleRecord.TitleRecordBuilder(fullTitle=" + this.fullTitle + ", abbreviatedTitle=" + this.abbreviatedTitle + ", tooltipTitle=" + this.tooltipTitle + ", tooltipBody=" + this.tooltipBody + ")";
            }
        }
    }
}

