/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.value;

import java.util.function.BiFunction;
import org.apache.causeway.applib.services.publishing.spi.PageRenderSubscriber;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.model.IModel;

@AuthorizeInstantiation(value={"org.apache.causeway.security.AUTHORIZED_USER_ROLE"})
public class ValuePage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_NAME = "actionName";
    private final ValueModel valueModel;

    public ValuePage(ValueModel valueModel, String actionName) {
        super(PageParameterUtils.newPageParameters(), actionName, UiComponentType.VALUE);
        this.valueModel = valueModel;
        Wkt.labelAdd(this.themeDiv, ID_ACTION_NAME, actionName);
        this.addChildComponents(this.themeDiv, (IModel<?>)valueModel);
        this.addBookmarkedPages(this.themeDiv);
    }

    @Override
    public void onRendering(Can<PageRenderSubscriber> enabledObjectRenderSubscribers) {
        this.onRenderingOrRendered(enabledObjectRenderSubscribers, (pageRenderSubscriber, value) -> {
            pageRenderSubscriber.onRenderingValue(value);
            return null;
        });
    }

    @Override
    public void onRendered(Can<PageRenderSubscriber> enabledObjectRenderSubscribers) {
        this.onRenderingOrRendered(enabledObjectRenderSubscribers, (pageRenderSubscriber, value) -> {
            pageRenderSubscriber.onRenderedValue(value);
            return null;
        });
    }

    private void onRenderingOrRendered(Can<PageRenderSubscriber> pageRenderSubscribers, BiFunction<PageRenderSubscriber, Object, Void> handler) {
        if (pageRenderSubscribers.isEmpty()) {
            return;
        }
        ManagedObjects.asSpecified((ManagedObject)this.valueModel.getObject()).ifPresent(managedObject -> {
            Object nullableValuePojo = managedObject.getPojo();
            pageRenderSubscribers.forEach(subscriber -> handler.apply((PageRenderSubscriber)subscriber, nullableValuePojo));
        });
    }
}

