/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.markup;

import java.util.EnumSet;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.markup.MarkupAttributePanelFactories;
import org.apache.causeway.viewer.wicket.ui.components.attributes.markup.MarkupComponent;
import org.apache.causeway.viewer.wicket.ui.components.attributes.value.ValueAttributePanel;
import org.apache.wicket.Component;

class MarkupAttributePanel<T>
extends ValueAttributePanel<T> {
    private static final long serialVersionUID = 1L;
    private final ComponentFactoryKey markupComponentFactoryKey;

    public MarkupAttributePanel(String id, UiAttributeWkt attributeModel, Class<T> valueType, ComponentFactoryKey markupComponentFactoryKey) {
        super(id, attributeModel, valueType);
        this.markupComponentFactoryKey = markupComponentFactoryKey;
    }

    @Override
    protected void setupFormatModifiers(EnumSet<AttributePanel.FormatModifier> modifiers) {
        modifiers.add(AttributePanel.FormatModifier.MARKUP);
        modifiers.add(AttributePanel.FormatModifier.MULTILINE);
    }

    @Override
    protected Component createComponentForOutput(String id) {
        return this.createMarkupComponent(id);
    }

    protected final MarkupComponent createMarkupComponent(String id) {
        return this.markupComponentFactory().newMarkupComponent(id, this.attributeModel());
    }

    protected final MarkupAttributePanelFactories.ParentedAbstract<?> markupComponentFactory() {
        return (MarkupAttributePanelFactories.ParentedAbstract)this.markupComponentFactoryKey.componentFactory();
    }
}

