/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.standalone;

import java.util.Optional;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.TableDecorator;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelStandalone;
import org.apache.causeway.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorProvider;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

class StandaloneCollectionPanel
extends PanelAbstract<DataTableInteractive, CollectionModel>
implements CollectionCountProvider,
CollectionPresentationSelectorProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_STANDALONE_COLLECTION = "standaloneCollection";
    private static final String ID_ACTION_NAME = "actionName";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final CollectionPresentationSelectorPanel selectorDropdownPanel;
    private MarkupContainer outerDiv = new WebMarkupContainer("standaloneCollection");
    private transient Optional<TableDecorator> tableDecorator;

    public StandaloneCollectionPanel(String id, CollectionModelStandalone collectionModel) {
        super(id, collectionModel);
        this.addOrReplace(new Component[]{this.outerDiv});
        DataTableInteractive table = collectionModel.getDataTableModel();
        Identifier featureId = collectionModel.getIdentifier();
        Wkt.labelAdd(this.outerDiv, ID_ACTION_NAME, (String)table.titleObservable().getValue());
        Wkt.cssAppend(this.outerDiv, featureId);
        Wkt.cssAppend(this.outerDiv, collectionModel.getElementType().getFeatureIdentifier());
        this.tableDecorator = collectionModel.getTableDecoratorIfAny();
        this.tableDecorator.ifPresent(tableDecorator -> Wkt.cssAppend(this.outerDiv, tableDecorator.cssClass()));
        CollectionPresentationSelectorHelper selectorHelper = new CollectionPresentationSelectorHelper((CollectionModel)collectionModel, this.getComponentFactoryRegistry());
        if (selectorHelper.factoryKeys().isCardinalityMultiple()) {
            CollectionPresentationSelectorPanel selectorDropdownPanel = new CollectionPresentationSelectorPanel(ID_SELECTOR_DROPDOWN, (CollectionModel)collectionModel);
            this.outerDiv.setOutputMarkupId(true);
            this.outerDiv.addOrReplace(new Component[]{selectorDropdownPanel});
            this.selectorDropdownPanel = selectorDropdownPanel;
        } else {
            WktComponents.permanentlyHide(this.outerDiv, ID_SELECTOR_DROPDOWN);
            this.selectorDropdownPanel = null;
        }
        this.getComponentFactoryRegistry().addOrReplaceComponent(this.outerDiv, UiComponentType.COLLECTION_CONTENTS, (IModel<?>)collectionModel);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.tableDecorator().ifPresent(tableDecorator -> this.renderHeadForTableDecorator(response, (TableDecorator)tableDecorator));
    }

    @Override
    public CollectionPresentationSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    @Override
    public Integer getCount() {
        CollectionModel model = (CollectionModel)this.getModel();
        return model.getElementCount();
    }

    private Optional<TableDecorator> tableDecorator() {
        if (this.tableDecorator == null) {
            CollectionModel collectionModel = (CollectionModel)this.getModel();
            this.tableDecorator = collectionModel.getTableDecoratorIfAny();
        }
        return this.tableDecorator;
    }
}

