/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.graph.tree.TreeNode;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.tree.TreeNodeMemento;
import org.apache.causeway.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.components.object.icontitle.ObjectIconAndTitlePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.tree.TreeExpansionModel;
import org.apache.causeway.viewer.wicket.ui.components.tree.TreeProvider;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.NestedTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

class DomainObjectTree
extends NestedTree<TreeNodeMemento>
implements HasMetaModelContext {
    private static final long serialVersionUID = 1L;

    static MarkupContainer emptyTreeComponent(String id) {
        return new WebMarkupContainer(id);
    }

    static MarkupContainer createComponent(String id, IModel<ManagedObject> rootModel) {
        return rootModel == null || ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)((ManagedObject)rootModel.getObject())) ? DomainObjectTree.emptyTreeComponent(id) : new DomainObjectTree(id, (TreeNode)((ManagedObject)rootModel.getObject()).getPojo());
    }

    private DomainObjectTree(String id, TreeNode<?> treeNode) {
        super(id, (ITreeProvider)new TreeProvider(treeNode), (IModel)TreeExpansionModel.of(treeNode.treeState()));
    }

    protected Component newContentComponent(String id, IModel<TreeNodeMemento> node) {
        TreeNodeMemento treeModel = (TreeNodeMemento)node.getObject();
        Component entityIconAndTitle = ObjectIconAndTitlePanelFactory.entityIconAndTitlePanel(id, (ObjectAdapterModel)UiObjectWkt.ofBookmark((Bookmark)treeModel.bookmark()));
        if (this.treeExpansionModel().isSelected(treeModel.treePath())) {
            Wkt.cssAppend(entityIconAndTitle, "tree-node-selected");
        }
        return entityIconAndTitle;
    }

    public Component newNodeComponent(String id, IModel<TreeNodeMemento> model) {
        Node<TreeNodeMemento> node = new Node<TreeNodeMemento>(id, (AbstractTree)this, model){
            private static final long serialVersionUID = 1L;

            protected Component createContent(String id, IModel<TreeNodeMemento> model) {
                return DomainObjectTree.this.newContentComponent(id, model);
            }

            protected MarkupContainer createJunctionComponent(String id) {
                final 1 node = this;
                final Runnable toggleExpandCollapse = (Runnable & Serializable)() -> this.toggle();
                return new AjaxFallbackLink<Void>(id){
                    private static final long serialVersionUID = 1L;

                    public void onClick(Optional<AjaxRequestTarget> target) {
                        toggleExpandCollapse.run();
                    }

                    public boolean isEnabled() {
                        return DomainObjectTree.this.getProvider().hasChildren((Object)((TreeNodeMemento)node.getModelObject()));
                    }

                    public boolean isEnabledInHierarchy() {
                        return true;
                    }
                };
            }
        };
        node.setOutputMarkupId(true);
        return node;
    }

    public AbstractTree.State getState(TreeNodeMemento t) {
        return this.treeExpansionModel().contains(t.treePath()) ? AbstractTree.State.EXPANDED : AbstractTree.State.COLLAPSED;
    }

    public void expand(TreeNodeMemento t) {
        this.treeExpansionModel().onExpand(t);
        super.expand((Object)t);
    }

    public void collapse(TreeNodeMemento t) {
        this.treeExpansionModel().onCollapse(t);
        super.collapse((Object)t);
    }

    private TreeExpansionModel treeExpansionModel() {
        return (TreeExpansionModel)this.getModel();
    }
}

