/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.select2;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.object.Bookmarkable;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.attrib.UiAttribute;
import org.apache.causeway.viewer.commons.model.attrib.UiParameter;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.wicket.util.string.Strings;
import org.jspecify.annotations.Nullable;
import org.wicketstuff.select2.Response;

record ChoiceProvider(UiAttributeWkt attributeModel, UiAttribute.ChoiceProviderSort choiceProviderSort) implements HasMetaModelContext,
Serializable
{
    public ChoiceProvider(UiAttributeWkt attributeModel) {
        this(attributeModel, UiAttribute.ChoiceProviderSort.valueOf((UiAttribute)attributeModel));
    }

    public String getDisplayValue(ObjectMemento choiceMemento) {
        if (choiceMemento == null || choiceMemento.isEmpty()) {
            return this.getPlaceholderRenderService().asText(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION);
        }
        return this.translate(choiceMemento.title());
    }

    public String getIdValue(ObjectMemento choiceMemento) {
        if (choiceMemento == null) {
            return "VGN6r6zKTiLhUsA0WkdQ17LvMU1IYdb0";
        }
        return ObjectMemento.enstringToUrlBase64((ObjectMemento)choiceMemento);
    }

    public void query(String term, int page, Response<ObjectMemento> response) {
        Can<ObjectMemento> mementosFiltered = this.query(term);
        if (this.isRequired()) {
            response.addAll((Collection)mementosFiltered.toList());
            return;
        }
        List mementosIncludingNull = mementosFiltered.toArrayList();
        mementosIncludingNull.add(0, null);
        response.addAll((Collection)mementosIncludingNull);
    }

    public Collection<ObjectMemento> toChoices(Collection<String> ids) {
        return _NullSafe.stream(ids).map(this::mementoFromIdWithNullHandling).collect(Collectors.toList());
    }

    org.wicketstuff.select2.ChoiceProvider<ObjectMemento> toSelect2ChoiceProvider() {
        final ChoiceProvider delegate = this;
        return new org.wicketstuff.select2.ChoiceProvider<ObjectMemento>(){
            private static final long serialVersionUID = 1L;

            public Collection<ObjectMemento> toChoices(Collection<String> ids) {
                return delegate.toChoices(ids);
            }

            public void query(String term, int page, Response<ObjectMemento> response) {
                delegate.query(term, page, response);
            }

            public String getIdValue(ObjectMemento object) {
                return delegate.getIdValue(object);
            }

            public String getDisplayValue(ObjectMemento object) {
                return delegate.getDisplayValue(object);
            }
        };
    }

    private Can<ObjectMemento> queryAll() {
        return this.attributeModel().getChoices().map(Bookmarkable::getMementoElseFail);
    }

    private Can<ObjectMemento> queryWithAutoCompleteUsingObjectSpecification(String term) {
        Can autoCompleteAdapters = Facets.autoCompleteExecute((ObjectSpecification)this.attributeModel().getElementType(), (String)term);
        return autoCompleteAdapters.map(Bookmarkable::getMementoElseFail);
    }

    private Can<ObjectMemento> queryWithAutoComplete(String term) {
        UiAttributeWkt attributeModel = this.attributeModel();
        Can pendingArgs = attributeModel.isParameter() ? ((UiParameter)attributeModel).getParameterNegotiationModel().getParamValues() : Can.empty();
        Can pendingArgMementos = pendingArgs.map(Bookmarkable::getMementoElseFail);
        if (attributeModel.isParameter()) {
            UiParameter paramModel = (UiParameter)attributeModel;
            paramModel.getParameterNegotiationModel().setParamValues(this.reconstructPendingArgs(paramModel, (Can<ObjectMemento>)pendingArgMementos));
        }
        return attributeModel.getAutoComplete(term).map(Bookmarkable::getMementoElseFail);
    }

    private Can<ManagedObject> reconstructPendingArgs(UiParameter parameterModel, Can<ObjectMemento> pendingArgMementos) {
        Can pendingArgsList = (Can)_NullSafe.stream(pendingArgMementos).map(arg_0 -> ((ObjectManager)this.getObjectManager()).demementify(arg_0)).collect(Can.toCan());
        return pendingArgsList;
    }

    private @Nullable ObjectMemento mementoFromIdWithNullHandling(String id) {
        if ("VGN6r6zKTiLhUsA0WkdQ17LvMU1IYdb0".equals(id)) {
            return null;
        }
        return this.mementoFromId(id);
    }

    private boolean isRequired() {
        return this.attributeModel().isRequired();
    }

    private Can<ObjectMemento> query(String term) {
        return switch (this.choiceProviderSort) {
            default -> throw new IncompatibleClassChangeError();
            case UiAttribute.ChoiceProviderSort.CHOICES -> this.filter(term, this.queryAll());
            case UiAttribute.ChoiceProviderSort.AUTO_COMPLETE -> this.queryWithAutoComplete(term);
            case UiAttribute.ChoiceProviderSort.OBJECT_AUTO_COMPLETE -> this.queryWithAutoCompleteUsingObjectSpecification(term);
            case UiAttribute.ChoiceProviderSort.NO_CHOICES -> Can.empty();
        };
    }

    private Can<ObjectMemento> filter(String term, Can<ObjectMemento> choiceMementos) {
        if (Strings.isEmpty((String)term)) {
            return choiceMementos;
        }
        TranslationContext translationContext = TranslationContext.empty();
        TranslationService translator = this.getTranslationService();
        String termLower = term.toLowerCase();
        return choiceMementos.filter(candidateMemento -> {
            String title = translator.translate(translationContext, candidateMemento.title());
            return title.toLowerCase().contains(termLower);
        });
    }

    private @Nullable ObjectMemento mementoFromId(@Nullable String id) {
        return ObjectMemento.destringFromUrlBase64((String)id);
    }
}

