/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actions;

import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.attrib.UiParameter;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.commons.model.decorators.ConfirmDecorator;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ParameterModel;
import org.apache.causeway.viewer.wicket.model.models.PropertyModel;
import org.apache.causeway.viewer.wicket.model.models.interaction.act.UiParameterWkt;
import org.apache.causeway.viewer.wicket.ui.components.actions._Xray;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.panels.PromptFormAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

class ActionParametersForm
extends PromptFormAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;

    public ActionParametersForm(String id, Component parentPanel, ActionModel actionModel) {
        super(id, parentPanel, actionModel);
    }

    protected ActionModel actionModel() {
        return (ActionModel)super.getModel();
    }

    @Override
    protected void addParameters() {
        ActionModel actionModel = this.actionModel();
        RepeatingView repeatingView = Wkt.add((MarkupContainer)this, new RepeatingView("parameters"));
        this.paramPanels.clear();
        actionModel.streamPendingParamUiModels().map(UiParameterWkt.class::cast).forEach(paramModel -> {
            WebMarkupContainer container = Wkt.containerAdd((MarkupContainer)repeatingView, repeatingView.newChildId());
            this.newParamPanel(container, (UiParameterWkt)paramModel, this.paramPanels::add);
        });
        this.setOutputMarkupId(true);
    }

    private void newParamPanel(WebMarkupContainer container, UiParameterWkt paramModel, Consumer<AttributePanel> onNewScalarPanel) {
        ParameterModel scalarParamModel = ParameterModel.wrap((UiParameterWkt)paramModel);
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, "attributeNameAndValue", UiComponentType.ATTRIBUTE_NAME_AND_VALUE, (IModel<?>)scalarParamModel);
        _Casts.castTo(AttributePanel.class, (Object)component).ifPresent(scalarPanel -> {
            scalarPanel.addChangeListener(this);
            onNewScalarPanel.accept((AttributePanel)scalarPanel);
        });
    }

    @Override
    protected void configureOkButton(AjaxButton okButton) {
        this.applyAreYouSure(okButton);
    }

    private void applyAreYouSure(AjaxButton button) {
        ActionModel actionModel = this.actionModel();
        ObjectAction action = actionModel.getAction();
        if (action.getSemantics().isAreYouSure()) {
            ConfirmDecorator.ConfirmDecorationModel confirmUiModel = ConfirmDecorator.ConfirmDecorationModel.areYouSure((UiPlacementDirection)UiPlacementDirection.BOTTOM);
            WktDecorators.confirm().decorate((Component)button, confirmUiModel);
        }
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, AttributePanel scalarPanelUpdated) {
        ActionModel actionModel = this.actionModel();
        UiParameter updatedParamModel = (UiParameter)scalarPanelUpdated.getModel();
        ParameterNegotiationModel paramNegotiationModel = updatedParamModel.getParameterNegotiationModel();
        Can pendingParamModels = (Can)actionModel.streamPendingParamUiModels().collect(Can.toCan());
        int paramIndexOfUpdated = updatedParamModel.getParameterIndex();
        _Xray.beforeParamFormUpdate(paramIndexOfUpdated, paramNegotiationModel);
        IntStream.range(paramIndexOfUpdated + 1, paramNegotiationModel.getParamCount()).forEach(paramIndexForReassessment -> {
            boolean wasValueChanged = paramNegotiationModel.reassessDefaults(paramIndexForReassessment);
            AttributePanel.Repaint paramRepaint = AttributePanel.Repaint.required(wasValueChanged);
            _Xray.reassessedDefault(paramIndexForReassessment, paramNegotiationModel);
            AttributePanel paramPanel = (AttributePanel)this.paramPanels.get(paramIndexForReassessment);
            UiParameterWkt paramModel = (UiParameterWkt)pendingParamModels.getElseFail(paramIndexForReassessment);
            paramRepaint = paramRepaint.max(paramPanel.updateIfNecessary((UiParameter)paramModel));
            switch (paramRepaint) {
                case REQUIRED: {
                    target.add(new Component[]{paramPanel});
                    break;
                }
                case REQUIRED_ON_PARENT: {
                    target.add(new Component[]{paramPanel.getParent()});
                    break;
                }
            }
        });
        _Xray.afterParamFormUpdate(paramIndexOfUpdated, paramNegotiationModel);
    }

    @Override
    protected Either<ActionModel, PropertyModel> getMemberModel() {
        return Either.left((Object)this.actionModel());
    }
}

