/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import org.apache.causeway.applib.graph.tree.TreeNode;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.tree.StandaloneTreePanel;
import org.apache.causeway.viewer.wicket.ui.components.tree.TreeAttributePanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class TreePanelFactories {
    public static ComponentFactory parented() {
        return new Parented();
    }

    public static ComponentFactory standalone() {
        return new Standalone();
    }

    static class Parented
    extends AttributeComponentFactory {
        public Parented() {
            super(TreeAttributePanel.class);
        }

        @Override
        protected ComponentFactory.ApplicationAdvice appliesTo(UiAttributeWkt attributeModel) {
            return this.appliesIf(attributeModel.isElementTypeSubtypeOf(TreeNode.class) && !attributeModel.hasChoices());
        }

        @Override
        protected Component createComponent(String id, UiAttributeWkt attributeModel) {
            return new TreeAttributePanel(id, attributeModel);
        }
    }

    static class Standalone
    extends ComponentFactoryAbstract {
        public Standalone() {
            super(UiComponentType.VALUE, StandaloneTreePanel.class);
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            ComponentFactory.ApplicationAdvice applicationAdvice;
            if (model instanceof ValueModel) {
                ValueModel valueModel = (ValueModel)model;
                applicationAdvice = this.appliesIf(ManagedObjects.correspondingClass((ManagedObject)valueModel.getObject()).map(TreeNode.class::isAssignableFrom).orElse(false));
            } else {
                applicationAdvice = ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return applicationAdvice;
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new StandaloneTreePanel(id, (ValueModel)model);
        }
    }
}

