/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.themepicker;

import de.agilecoders.wicket.core.settings.NoopThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.viewer.wicket.ui.components.widgets.themepicker.CausewayWicketThemeSupport;
import org.apache.causeway.viewer.wicket.ui.components.widgets.themepicker.ThemeProviderComposite;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.wicket.CausewayWicketThemeSupportDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class CausewayWicketThemeSupportDefault
implements CausewayWicketThemeSupport {
    @Generated
    private static final Logger log = LogManager.getLogger(CausewayWicketThemeSupportDefault.class);
    private final _Lazy<ThemeProviderComposite> themeProvider = _Lazy.threadSafe(this::createThemeProvider);
    @Inject
    private CausewayConfiguration configuration;
    @Inject
    private ServiceRegistry serviceRegistry;

    @Override
    public ThemeProvider getThemeProvider() {
        return (ThemeProvider)this.themeProvider.get();
    }

    @Override
    public List<String> getEnabledThemeNames() {
        ThemeProviderComposite composite = (ThemeProviderComposite)this.themeProvider.get();
        List<String> allThemes = composite.availableNames();
        allThemes = this.filterThemes(allThemes);
        return allThemes;
    }

    private ThemeProviderComposite createThemeProvider() {
        Can providerBeans = this.serviceRegistry.select(ThemeProvider.class);
        if (providerBeans.isEmpty()) {
            return ThemeProviderComposite.of((Can<ThemeProvider>)Can.ofSingleton((Object)this.createFallbackThemeProvider()));
        }
        return ThemeProviderComposite.of((Can<ThemeProvider>)providerBeans);
    }

    private ThemeProvider createFallbackThemeProvider() {
        BootswatchTheme bootswatchTheme;
        String themeName = this.configuration.getViewer().getWicket().getThemes().getInitial();
        if ("default".equalsIgnoreCase(themeName)) {
            return new NoopThemeProvider();
        }
        try {
            bootswatchTheme = BootswatchTheme.valueOf((String)themeName);
        }
        catch (Exception ex) {
            bootswatchTheme = BootswatchTheme.Flatly;
            log.warn("Did not recognise configured bootswatch theme '{}', defaulting to '{}'", (Object)themeName, (Object)bootswatchTheme);
        }
        return new BootswatchThemeProvider(bootswatchTheme);
    }

    private List<String> filterThemes(List<String> availableThemes) {
        List configuredThemes = this.configuration.getViewer().getWicket().getThemes().getEnabled();
        if (configuredThemes == null || configuredThemes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> enabledThemes = new ArrayList<String>();
        availableThemes.stream().filter(availableTheme -> configuredThemes.stream().anyMatch(configuredTheme -> configuredTheme.equalsIgnoreCase((String)availableTheme))).forEach(enabledThemes::add);
        return enabledThemes;
    }
}

