/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.integration;

import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.applib.clock.VirtualClock;
import org.apache.causeway.applib.services.clock.ClockService;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.session.SessionSubscriber;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.security.authentication.AuthenticationRequest;
import org.apache.causeway.core.security.authentication.AuthenticationRequestPassword;
import org.apache.causeway.core.security.authentication.manager.AuthenticationManager;
import org.apache.causeway.viewer.wicket.model.causeway.HasAmendableInteractionContext;
import org.apache.causeway.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.causeway.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.springframework.lang.Nullable;

public class AuthenticatedWebSessionForCauseway
extends AuthenticatedWebSession
implements BreadcrumbModelProvider,
BookmarkedPagesModelProvider,
HasCommonContext,
HasAmendableInteractionContext {
    private static final Logger log = LogManager.getLogger(AuthenticatedWebSessionForCauseway.class);
    private static final long serialVersionUID = 1L;
    private BreadcrumbModel breadcrumbModel;
    private BookmarkedPagesModel bookmarkedPagesModel;
    private InteractionContext interactionContext;
    private UUID sessionGuid = UUID.randomUUID();
    private String cachedSessionId;

    public static AuthenticatedWebSessionForCauseway get() {
        return (AuthenticatedWebSessionForCauseway)Session.get();
    }

    public BreadcrumbModel getBreadcrumbModel() {
        return this.breadcrumbModel != null ? this.breadcrumbModel : (this.breadcrumbModel = new BreadcrumbModel());
    }

    public BookmarkedPagesModel getBookmarkedPagesModel() {
        return this.bookmarkedPagesModel != null ? this.bookmarkedPagesModel : (this.bookmarkedPagesModel = new BookmarkedPagesModel());
    }

    private void setInteractionContext(@Nullable InteractionContext interactionContext) {
        _Assert.assertFalse((interactionContext != null && interactionContext.getUser().isImpersonating() ? 1 : 0) != 0, () -> "framework bug: cannot signin with an impersonated user");
        this.interactionContext = interactionContext;
    }

    public void setPrimedInteractionContext(@NonNull InteractionContext authentication) {
        if (authentication == null) {
            throw new NullPointerException("authentication is marked non-null but is null");
        }
        this.interactionContext = authentication;
    }

    public Optional<String> getCachedSessionId() {
        if (this.cachedSessionId == null && Session.exists()) {
            this.cachedSessionId = this.getId();
        }
        return Optional.ofNullable(this.cachedSessionId);
    }

    public AuthenticatedWebSessionForCauseway(Request request) {
        super(request);
    }

    public synchronized boolean authenticate(String username, String password) {
        AuthenticationRequestPassword authenticationRequest = new AuthenticationRequestPassword(username, password);
        authenticationRequest.addRole("org.apache.causeway.security.AUTHORIZED_USER_ROLE");
        InteractionContext interactionContext = this.getAuthenticationManager().authenticate((AuthenticationRequest)authenticationRequest);
        this.setInteractionContext(interactionContext);
        if (interactionContext != null) {
            this.log(SessionSubscriber.Type.LOGIN, username, null);
            return true;
        }
        return false;
    }

    public synchronized void invalidateNow() {
        this.getAuthenticationManager().closeSession((UserMemento)Optional.ofNullable(this.interactionContext).map(InteractionContext::getUser).orElse(null));
        super.invalidateNow();
    }

    public synchronized void onInvalidate() {
        String userName = null;
        InteractionContext authentication = this.getInteractionContext();
        if (authentication != null) {
            userName = authentication.getUser().getName();
        }
        super.onInvalidate();
        SessionSubscriber.CausedBy causedBy = RequestCycle.get() != null ? SessionSubscriber.CausedBy.USER : SessionSubscriber.CausedBy.SESSION_EXPIRATION;
        this.log(SessionSubscriber.Type.LOGOUT, userName, causedBy);
    }

    public void amendInteractionContext(UnaryOperator<InteractionContext> updater) {
        this.setInteractionContext((InteractionContext)updater.apply(this.interactionContext));
    }

    synchronized InteractionContext getInteractionContext() {
        if (this.interactionContext == null) {
            return null;
        }
        if (Optional.ofNullable(this.getMetaModelContext()).map(HasMetaModelContext::getAuthenticationManager).filter(x -> x.isSessionValid(this.interactionContext)).isEmpty()) {
            return null;
        }
        this.signIn(true);
        return this.interactionContext;
    }

    public AuthenticationManager getAuthenticationManager() {
        return Optional.ofNullable(this.getMetaModelContext()).map(HasMetaModelContext::getAuthenticationManager).orElse(null);
    }

    public void invalidate() {
        if (this.interactionContext != null && this.interactionContext.getUser().getAuthenticationSource().isExternal()) {
            return;
        }
        super.invalidate();
    }

    public synchronized Roles getRoles() {
        if (!this.isSignedIn()) {
            return null;
        }
        return this.getInteractionService().currentInteractionContext().map(InteractionContext::getUser).map(user -> {
            Roles roles = new Roles();
            user.streamRoleNames().forEach(arg_0 -> roles.add(arg_0));
            return roles;
        }).orElse(null);
    }

    public synchronized void detach() {
        if (this.breadcrumbModel != null) {
            this.breadcrumbModel.detach();
        }
        if (this.bookmarkedPagesModel != null) {
            this.bookmarkedPagesModel.detach();
        }
        super.detach();
    }

    public void replaceSession() {
    }

    private void log(SessionSubscriber.Type type, String username, SessionSubscriber.CausedBy causedBy) {
        if (this.getMetaModelContext() == null) {
            log.warn("Failed to callback SessionLoggingServices due to unavailable MetaModelContext.\n\tEvent Data: type={}, username={}, causedBy={}", (Object)type, (Object)username, (Object)causedBy);
            return;
        }
        InteractionService interactionService = this.getInteractionService();
        Can<SessionSubscriber> sessionLoggingServices = this.getSessionLoggingServices();
        Runnable loggingTask = () -> {
            Date now = this.virtualClock().nowAsJavaUtilDate();
            String httpSessionId = this.getCachedSessionId().orElse("(none)");
            sessionLoggingServices.forEach(sessionLoggingService -> sessionLoggingService.log(type, username, now, causedBy, this.getSessionGuid(), httpSessionId));
        };
        if (interactionService != null) {
            interactionService.runAnonymous(loggingTask::run);
        } else {
            loggingTask.run();
        }
    }

    protected Can<SessionSubscriber> getSessionLoggingServices() {
        return this.getServiceRegistry().select(SessionSubscriber.class);
    }

    private VirtualClock virtualClock() {
        try {
            return this.getServiceRegistry().lookupService(ClockService.class).map(ClockService::getClock).orElseGet(this::nowFallback);
        }
        catch (Exception e) {
            return this.nowFallback();
        }
    }

    private VirtualClock nowFallback() {
        return VirtualClock.system();
    }

    public UUID getSessionGuid() {
        return this.sessionGuid;
    }
}

