/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.components;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.causeway.applib.value.semantics.ValueSemanticsProvider;
import org.apache.causeway.applib.value.semantics.ValueSemanticsResolver;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.apache.causeway.core.metamodel.commons.ClassUtil;
import org.apache.causeway.core.metamodel.tabular.simple.CollectionContentsExporter;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistrar;
import org.apache.causeway.viewer.wicket.ui.components.about.AboutPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actioninfo.ActionInfoPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceActionsPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actionmenu.serviceactions.TertiaryMenuPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actions.ActionParametersFormPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actions.ActionParametersPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.bookmarkedpages.BookmarkedPagesPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsAsAjaxTablePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.export.CollectionContentsAsExportFactory;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.multiple.CollectionContentsMultipleViewsPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.summary.CollectionContentsAsSummaryFactory;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.unresolved.CollectionContentsHiddenPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.empty.EmptyCollectionPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.entity.collection.EntityCollectionPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.entity.header.EntityHeaderPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.entity.icontitle.EntityIconAndTitlePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.entity.icontitle.EntityIconTitleAndCopyLinkPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.footer.FooterPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.header.HeaderPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.BSGridPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.property.PropertyEditFormPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.property.PropertyEditPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ComponentFactoryScalarTypeConstrainedAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldNumeric;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldWithTemporalPicker;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldWithValueSemantics;
import org.apache.causeway.viewer.wicket.ui.components.scalars.blobclob.CausewayBlobPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.blobclob.CausewayClobPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.bool.BooleanPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.choices.ChoicesSelect2PanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.composite.CompositeValuePanel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.image.JavaAwtImagePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.markup.MarkupPanelFactories;
import org.apache.causeway.viewer.wicket.ui.components.scalars.passwd.CausewayPasswordPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.string.StringPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.value.fallback.ValueFallbackPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.standalonecollection.StandaloneCollectionPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.tree.TreePanelFactories;
import org.apache.causeway.viewer.wicket.ui.components.unknown.UnknownModelPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.value.StandaloneValuePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.voidreturn.VoidReturnPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.welcome.WelcomePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.widgets.entitysimplelink.EntityLinkSimplePanelFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Component;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
@Named(value="causeway.viewer.wicket.ComponentFactoryRegistrarDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class ComponentFactoryRegistrarDefault
implements ComponentFactoryRegistrar {
    private static final Logger log = LogManager.getLogger(ComponentFactoryRegistrarDefault.class);
    @Inject
    private ValueSemanticsResolver valueSemanticsResolver;
    @Autowired(required=false)
    private List<CollectionContentsExporter> collectionContentsExporters;
    private final List<ComponentFactory> componentFactoriesPluggedIn;

    public ComponentFactoryRegistrarDefault(List<ComponentFactory> componentFactoriesPluggedIn) {
        this.componentFactoriesPluggedIn = componentFactoriesPluggedIn;
    }

    public void addComponentFactories(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        this.addComponentFactoriesActingAsSelectors(componentFactories);
        this.addComponentFactoriesFromPlugins(componentFactories);
        this.addBuiltInComponentFactories(componentFactories);
    }

    protected void addComponentFactoriesActingAsSelectors(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        this.addLinksSelectorFactories(componentFactories);
        componentFactories.add((ComponentFactory)new CollectionContentsHiddenPanelFactory());
    }

    protected void addLinksSelectorFactories(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new CollectionContentsMultipleViewsPanelFactory());
    }

    protected void addComponentFactoriesFromPlugins(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        log.info("adding {} ComponentFactories from plugins: {}", (Object)_NullSafe.size(this.componentFactoriesPluggedIn), this.componentFactoriesPluggedIn);
        _NullSafe.stream(this.componentFactoriesPluggedIn).forEach(arg_0 -> ((ComponentFactoryRegistrar.ComponentFactoryList)componentFactories).add(arg_0));
    }

    private void addBuiltInComponentFactories(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        this.addComponentFactoriesForWelcomeAndAbout(componentFactories);
        this.addComponentFactoriesForApplicationActions(componentFactories);
        this.addComponentFactoriesForEntity(componentFactories);
        this.addComponentFactoriesForActionInfo(componentFactories);
        this.addComponentFactoriesForAction(componentFactories);
        this.addComponentFactoriesForPropertyEdit(componentFactories);
        this.addComponentFactoriesForEntityCollectionContents(componentFactories);
        this.addComponentFactoriesForEmptyCollection(componentFactories);
        this.addComponentFactoriesForScalar(componentFactories);
        this.addComponentFactoriesForEntityLink(componentFactories);
        this.addComponentFactoriesForVoidReturn(componentFactories);
        this.addComponentFactoriesForValue(componentFactories);
        this.addComponentFactoriesForParameters(componentFactories);
        this.addComponentFactoriesForBreadcrumbs(componentFactories);
        this.addComponentFactoriesForPageHeader(componentFactories);
        this.addComponentFactoriesForPageFooter(componentFactories);
        this.addComponentFactoriesForUnknown(componentFactories);
    }

    protected void addComponentFactoriesForPageHeader(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new HeaderPanelFactory());
    }

    protected void addComponentFactoriesForPageFooter(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new FooterPanelFactory());
    }

    protected void addComponentFactoriesForWelcomeAndAbout(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new WelcomePanelFactory());
        componentFactories.add((ComponentFactory)new AboutPanelFactory());
    }

    protected void addComponentFactoriesForEntity(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new BSGridPanelFactory());
        componentFactories.add((ComponentFactory)new EntityIconAndTitlePanelFactory());
        componentFactories.add((ComponentFactory)new EntityIconTitleAndCopyLinkPanelFactory());
        componentFactories.add((ComponentFactory)new EntityHeaderPanelFactory());
        componentFactories.add((ComponentFactory)new EntityCollectionPanelFactory());
    }

    protected void addComponentFactoriesForEntityCollectionContents(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new CollectionContentsAsAjaxTablePanelFactory());
        _NullSafe.stream(this.collectionContentsExporters).map(CollectionContentsAsExportFactory::new).forEach(arg_0 -> ((ComponentFactoryRegistrar.ComponentFactoryList)componentFactories).add(arg_0));
        componentFactories.add((ComponentFactory)new CollectionContentsAsSummaryFactory());
    }

    protected void addComponentFactoriesForEmptyCollection(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new EmptyCollectionPanelFactory());
    }

    protected void addComponentFactoriesForValue(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add(MarkupPanelFactories.standalone());
        componentFactories.add(TreePanelFactories.standalone());
        componentFactories.add((ComponentFactory)new StandaloneValuePanelFactory());
    }

    protected void addComponentFactoriesForScalar(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add(TreePanelFactories.parented());
        componentFactories.add(MarkupPanelFactories.parented());
        componentFactories.add((ComponentFactory)new BooleanPanelFactory());
        componentFactories.add((ComponentFactory)new StringPanelFactory());
        componentFactories.add((ComponentFactory)new JavaAwtImagePanelFactory());
        componentFactories.add((ComponentFactory)new CausewayPasswordPanelFactory());
        componentFactories.add((ComponentFactory)new CausewayBlobPanelFactory());
        componentFactories.add((ComponentFactory)new CausewayClobPanelFactory());
        this.addGenericComponentFactoriesForScalar(componentFactories);
        componentFactories.add((ComponentFactory)new ValueFallbackPanelFactory());
        componentFactories.add((ComponentFactory)new ChoicesSelect2PanelFactory());
    }

    protected void addComponentFactoriesForEntityLink(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new EntityLinkSimplePanelFactory());
    }

    protected void addComponentFactoriesForVoidReturn(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new VoidReturnPanelFactory());
    }

    protected void addComponentFactoriesForActionInfo(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ActionInfoPanelFactory());
    }

    protected void addComponentFactoriesForParameters(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ActionParametersFormPanelFactory());
    }

    protected void addComponentFactoriesForAction(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ActionParametersPanelFactory());
        componentFactories.add((ComponentFactory)new StandaloneCollectionPanelFactory());
    }

    protected void addComponentFactoriesForPropertyEdit(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new PropertyEditPanelFactory());
        componentFactories.add((ComponentFactory)new PropertyEditFormPanelFactory());
    }

    protected void addComponentFactoriesForApplicationActions(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ServiceActionsPanelFactory());
        componentFactories.add((ComponentFactory)new TertiaryMenuPanelFactory());
    }

    protected void addComponentFactoriesForBreadcrumbs(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new BookmarkedPagesPanelFactory());
    }

    protected void addComponentFactoriesForUnknown(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new UnknownModelPanelFactory());
    }

    public static <T extends Serializable> ComponentFactoryScalarTypeConstrainedAbstract createForValueSemantics(ValueSemanticsProvider<T> valueSemantics) {
        if (valueSemantics.isNumberType()) {
            return new ScalarPanelFactoryForNumberField(valueSemantics.getCorrespondingClass());
        }
        if (valueSemantics.isTemporalType()) {
            return (ComponentFactoryScalarTypeConstrainedAbstract)_Casts.uncheckedCast(new ScalarPanelFactoryForTemporalPicker(valueSemantics.getCorrespondingClass()));
        }
        if (valueSemantics.isCompositeType()) {
            return new ScalarPanelFactoryForCompositeValue(valueSemantics.getCorrespondingClass());
        }
        return new ScalarPanelFactoryForTextField(valueSemantics.getCorrespondingClass());
    }

    private void addGenericComponentFactoriesForScalar(ComponentFactoryRegistrar.ComponentFactoryList componentFactories) {
        Set registeredScalarTypes = componentFactories.stream(ComponentFactoryScalarTypeConstrainedAbstract.class).flatMap(f -> f.getScalarTypes().stream()).collect(Collectors.toSet());
        this.valueSemanticsResolver.streamClassesWithValueSemantics().filter(_Predicates.not(registeredScalarTypes::contains)).flatMap(arg_0 -> ((ValueSemanticsResolver)this.valueSemanticsResolver).streamValueSemantics(arg_0)).map(valueSemantics -> ComponentFactoryRegistrarDefault.createForValueSemantics(valueSemantics)).forEach(arg_0 -> ((ComponentFactoryRegistrar.ComponentFactoryList)componentFactories).add(arg_0));
    }

    private static Can<Class<?>> withPrimitiveVariant(@NonNull Class<?> valueTypeClass) {
        if (valueTypeClass == null) {
            throw new NullPointerException("valueTypeClass is marked non-null but is null");
        }
        Can valueTypeClasses = Can.ofSingleton(valueTypeClass);
        if (ClassUtils.isPrimitiveWrapper(valueTypeClass)) {
            Class unboxed = ClassUtil.unboxPrimitiveIfNecessary(valueTypeClass);
            valueTypeClasses = valueTypeClasses.add((Object)unboxed);
        }
        return valueTypeClasses;
    }

    public static class ScalarPanelFactoryForNumberField<T extends Serializable>
    extends ComponentFactoryScalarTypeConstrainedAbstract {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForNumberField(Class<T> valueTypeClass) {
            super(ScalarPanelTextFieldNumeric.class, ComponentFactoryRegistrarDefault.withPrimitiveVariant(valueTypeClass));
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, ScalarModel scalarModel) {
            return new ScalarPanelTextFieldNumeric(id, scalarModel, this.valueTypeClass);
        }
    }

    public static class ScalarPanelFactoryForTemporalPicker<T extends Serializable & Temporal>
    extends ComponentFactoryScalarTypeConstrainedAbstract {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForTemporalPicker(Class<T> valueTypeClass) {
            super(ScalarPanelTextFieldWithTemporalPicker.class, valueTypeClass);
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, ScalarModel scalarModel) {
            return new ScalarPanelTextFieldWithTemporalPicker(id, scalarModel, this.valueTypeClass);
        }
    }

    public static class ScalarPanelFactoryForCompositeValue<T extends Serializable>
    extends ComponentFactoryScalarTypeConstrainedAbstract {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForCompositeValue(Class<T> valueTypeClass) {
            super(CompositeValuePanel.class, valueTypeClass);
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, ScalarModel scalarModel) {
            return new CompositeValuePanel(id, scalarModel, this.valueTypeClass);
        }
    }

    public static class ScalarPanelFactoryForTextField<T extends Serializable>
    extends ComponentFactoryScalarTypeConstrainedAbstract {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForTextField(Class<T> valueTypeClass) {
            super(ScalarPanelTextFieldWithValueSemantics.class, ComponentFactoryRegistrarDefault.withPrimitiveVariant(valueTypeClass));
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, ScalarModel scalarModel) {
            return new ScalarPanelTextFieldWithValueSemantics(id, scalarModel, this.valueTypeClass);
        }
    }
}

