/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.wicketapp.config;

import de.agilecoders.wicket.webjars.WicketWebjars;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.settings.WebjarsSettings;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.viewer.wicket.model.causeway.WicketApplicationInitializer;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={JavaScriptModuleMimeSupport.class})
public class WebjarsInitWkt
implements WicketApplicationInitializer {
    public void init(WebApplication webApplication) {
        WebjarsSettings settings = new WebjarsSettings();
        WicketWebjars.install((WebApplication)webApplication, (IWebjarsSettings)settings);
    }

    @Configuration
    public static class JavaScriptModuleMimeSupport
    implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
        public void customize(ConfigurableServletWebServerFactory factory) {
            MimeMappings mappings = _Casts.castTo(AbstractServletWebServerFactory.class, (Object)factory).map(AbstractServletWebServerFactory::getMimeMappings).orElseGet(() -> new MimeMappings(MimeMappings.DEFAULT));
            mappings.remove("mjs");
            mappings.add("mjs", "application/javascript;charset=utf-8");
            factory.setMimeMappings(mappings);
        }
    }
}

